/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.MathUtil;
import javax.annotation.Nullable;

public final class FloatSubject
extends ComparableSubject<FloatSubject, Float> {
    private static final int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);

    FloatSubject(FailureStrategy failureStrategy, @Nullable Float subject) {
        super(failureStrategy, subject);
    }

    public TolerantFloatComparison isWithin(final float tolerance) {
        return new TolerantFloatComparison(){

            @Override
            public void of(float expected) {
                Float actual = (Float)FloatSubject.this.actual();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (Object)Float.valueOf(tolerance), (Object)Float.valueOf(expected));
                FloatSubject.checkTolerance(tolerance);
                if (!MathUtil.equalWithinTolerance(actual.floatValue(), expected, tolerance)) {
                    FloatSubject.this.failWithRawMessage("%s and <%s> should have been finite values within <%s> of each other", FloatSubject.this.actualAsString(), Float.valueOf(expected), Float.valueOf(tolerance));
                }
            }
        };
    }

    public TolerantFloatComparison isNotWithin(final float tolerance) {
        return new TolerantFloatComparison(){

            @Override
            public void of(float expected) {
                Float actual = (Float)FloatSubject.this.actual();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (Object)Float.valueOf(tolerance), (Object)Float.valueOf(expected));
                FloatSubject.checkTolerance(tolerance);
                if (!MathUtil.notEqualWithinTolerance(actual.floatValue(), expected, tolerance)) {
                    FloatSubject.this.failWithRawMessage("%s and <%s> should have been finite values not within <%s> of each other", FloatSubject.this.actualAsString(), Float.valueOf(expected), Float.valueOf(tolerance));
                }
            }
        };
    }

    public final void isEqualTo(@Nullable Float other) {
        super.isEqualTo(other);
    }

    public final void isNotEqualTo(@Nullable Float other) {
        super.isNotEqualTo(other);
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(Float other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    static void checkTolerance(float tolerance) {
        Preconditions.checkArgument((!Float.isNaN(tolerance) ? 1 : 0) != 0, (Object)"tolerance cannot be NaN");
        Preconditions.checkArgument((tolerance >= 0.0f ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (Object)Float.valueOf(tolerance));
        Preconditions.checkArgument((Float.floatToIntBits(tolerance) != NEG_ZERO_BITS ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (Object)Float.valueOf(tolerance));
        Preconditions.checkArgument((tolerance != Float.POSITIVE_INFINITY ? 1 : 0) != 0, (Object)"tolerance cannot be POSITIVE_INFINITY");
    }

    public final void isZero() {
        if (this.actual() == null || ((Float)this.actual()).floatValue() != 0.0f) {
            this.fail("is zero");
        }
    }

    public final void isNonZero() {
        if (this.actual() == null || ((Float)this.actual()).floatValue() == 0.0f) {
            this.fail("is non-zero");
        }
    }

    public final void isPositiveInfinity() {
        this.isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
    }

    public final void isNegativeInfinity() {
        this.isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    public final void isNaN() {
        this.isEqualTo(Float.valueOf(Float.NaN));
    }

    public final void isFinite() {
        if (this.actual() == null || ((Float)this.actual()).isNaN() || ((Float)this.actual()).isInfinite()) {
            this.failWithRawMessage("%s should have been finite", this.actualAsString());
        }
    }

    public final void isNotNaN() {
        if (this.actual() == null || ((Float)this.actual()).isNaN()) {
            this.failWithRawMessage("%s should not have been NaN", this.actualAsString());
        }
    }

    public static abstract class TolerantFloatComparison {
        private TolerantFloatComparison() {
        }

        public abstract void of(float var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare floats, use .of(float) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

