/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotatedCodeElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public interface ParameterDescription
extends AnnotatedCodeElement,
NamedElement.WithRuntimeName,
ModifierReviewable,
ByteCodeElement.TypeDependant<InDefinedShape, Token> {
    public static final String NAME_PREFIX = "arg";

    public GenericTypeDescription getType();

    public MethodDescription getDeclaringMethod();

    public int getIndex();

    public boolean isNamed();

    public boolean hasModifiers();

    public int getOffset();

    public static class Token
    implements ByteCodeElement.Token<Token> {
        public static final String NO_NAME = null;
        public static final Integer NO_MODIFIERS = null;
        private final GenericTypeDescription typeDescription;
        private final List<? extends AnnotationDescription> annotationDescriptions;
        private final String name;
        private final Integer modifiers;

        public Token(GenericTypeDescription typeDescription) {
            this(typeDescription, Collections.emptyList());
        }

        public Token(GenericTypeDescription typeDescription, List<? extends AnnotationDescription> annotationDescriptions) {
            this(typeDescription, annotationDescriptions, NO_NAME, NO_MODIFIERS);
        }

        public Token(GenericTypeDescription typeDescription, List<? extends AnnotationDescription> annotationDescriptions, String name, Integer modifiers) {
            this.typeDescription = typeDescription;
            this.annotationDescriptions = annotationDescriptions;
            this.name = name;
            this.modifiers = modifiers;
        }

        public GenericTypeDescription getType() {
            return this.typeDescription;
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotationDescriptions);
        }

        public String getName() {
            return this.name;
        }

        public Integer getModifiers() {
            return this.modifiers;
        }

        @Override
        public Token accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            return new Token(this.getType().accept(visitor), this.getAnnotations(), this.getName(), this.getModifiers());
        }

        @Override
        public boolean isIdenticalTo(Token token) {
            return this.getType().equals(token.getType()) && this.getAnnotations().equals(token.getAnnotations()) && (this.getName() == null && token.getName() == null || this.getName() != null && token.getName() != null && this.getName().equals(token.getName())) && (this.getModifiers() == null && token.getModifiers() == null || this.getModifiers() != null && token.getModifiers() != null && this.getModifiers().equals(token.getModifiers()));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            String name = this.getName();
            return name != null && name.equals(((Token)other).getName());
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : super.hashCode();
        }

        public String toString() {
            return "ParameterDescription.Token{typeDescription=" + this.typeDescription + ", annotationDescriptions=" + this.annotationDescriptions + ", name='" + this.name + '\'' + ", modifiers=" + this.modifiers + '}';
        }

        public static class TypeList
        extends AbstractList<Token> {
            private final List<? extends GenericTypeDescription> typeDescriptions;

            public TypeList(List<? extends GenericTypeDescription> typeDescriptions) {
                this.typeDescriptions = typeDescriptions;
            }

            @Override
            public Token get(int index) {
                return new Token(this.typeDescriptions.get(index));
            }

            @Override
            public int size() {
                return this.typeDescriptions.size();
            }
        }
    }

    public static class TypeSubstituting
    extends AbstractBase {
        private final MethodDescription declaringMethod;
        private final ParameterDescription parameterDescription;
        private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor;

        public TypeSubstituting(MethodDescription declaringMethod, ParameterDescription parameterDescription, GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            this.declaringMethod = declaringMethod;
            this.parameterDescription = parameterDescription;
            this.visitor = visitor;
        }

        @Override
        public GenericTypeDescription getType() {
            return this.parameterDescription.getType().accept(this.visitor);
        }

        @Override
        public MethodDescription getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.parameterDescription.getIndex();
        }

        @Override
        public boolean isNamed() {
            return this.parameterDescription.isNamed();
        }

        @Override
        public boolean hasModifiers() {
            return this.parameterDescription.hasModifiers();
        }

        @Override
        public int getOffset() {
            return this.parameterDescription.getOffset();
        }

        @Override
        public String getName() {
            return this.parameterDescription.getName();
        }

        @Override
        public int getModifiers() {
            return this.parameterDescription.getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.parameterDescription.getDeclaredAnnotations();
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.parameterDescription.asDefined();
        }
    }

    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final MethodDescription.InDefinedShape declaringMethod;
        private final GenericTypeDescription parameterType;
        private final List<? extends AnnotationDescription> declaredAnnotations;
        private final String name;
        private final Integer modifiers;
        private final int index;
        private final int offset;

        public Latent(MethodDescription.InDefinedShape declaringMethod, Token token, int index, int offset) {
            this(declaringMethod, token.getType(), token.getAnnotations(), token.getName(), token.getModifiers(), index, offset);
        }

        public Latent(MethodDescription.InDefinedShape declaringMethod, GenericTypeDescription parameterType, int index, int offset) {
            this(declaringMethod, parameterType, Collections.emptyList(), Token.NO_NAME, Token.NO_MODIFIERS, index, offset);
        }

        public Latent(MethodDescription.InDefinedShape declaringMethod, GenericTypeDescription parameterType, List<? extends AnnotationDescription> declaredAnnotations, String name, Integer modifiers, int index, int offset) {
            this.declaringMethod = declaringMethod;
            this.parameterType = parameterType;
            this.declaredAnnotations = declaredAnnotations;
            this.name = name;
            this.modifiers = modifiers;
            this.index = index;
            this.offset = offset;
        }

        @Override
        public GenericTypeDescription getType() {
            return this.parameterType.accept(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public MethodDescription.InDefinedShape getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public boolean isNamed() {
            return this.name != null;
        }

        @Override
        public boolean hasModifiers() {
            return this.modifiers != null;
        }

        @Override
        public String getName() {
            return this.isNamed() ? this.name : super.getName();
        }

        @Override
        public int getModifiers() {
            return this.hasModifiers() ? this.modifiers.intValue() : super.getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }
    }

    public static class ForLoadedParameter
    extends InDefinedShape.AbstractBase {
        private static final Dispatcher DISPATCHER;
        private final Object parameter;
        private final int index;

        protected ForLoadedParameter(Object parameter, int index) {
            this.parameter = parameter;
            this.index = index;
        }

        @Override
        public GenericTypeDescription getType() {
            return new GenericTypeDescription.LazyProjection.OfLoadedParameter(this.parameter);
        }

        @Override
        public MethodDescription.InDefinedShape getDeclaringMethod() {
            Object executable = DISPATCHER.getDeclaringExecutable(this.parameter);
            if (executable instanceof Method) {
                return new MethodDescription.ForLoadedMethod((Method)executable);
            }
            if (executable instanceof Constructor) {
                return new MethodDescription.ForLoadedConstructor((Constructor)executable);
            }
            throw new IllegalStateException("Unknown executable type: " + executable);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(DISPATCHER.getDeclaredAnnotations(this.parameter));
        }

        @Override
        public String getName() {
            return DISPATCHER.getName(this.parameter);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isNamed() {
            return DISPATCHER.isNamePresent(this.parameter);
        }

        @Override
        public int getModifiers() {
            return DISPATCHER.getModifiers(this.parameter);
        }

        @Override
        public boolean hasModifiers() {
            return this.isNamed() || this.getModifiers() != 0;
        }

        static {
            Dispatcher dispatcher;
            try {
                Class<?> parameterType = Class.forName("java.lang.reflect.Parameter");
                dispatcher = new Dispatcher.ForModernVm(parameterType.getDeclaredMethod("getName", new Class[0]), parameterType.getDeclaredMethod("getDeclaringExecutable", new Class[0]), parameterType.getDeclaredMethod("isNamePresent", new Class[0]), parameterType.getDeclaredMethod("getModifiers", new Class[0]), parameterType.getDeclaredMethod("getDeclaredAnnotations", new Class[0]));
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception ignored) {
                dispatcher = Dispatcher.ForLegacyVm.INSTANCE;
            }
            DISPATCHER = dispatcher;
        }

        protected static class OfLegacyVmConstructor
        extends InDefinedShape.AbstractBase {
            private final Constructor<?> constructor;
            private final int index;
            private final Class<?> parameterType;
            private final Annotation[] parameterAnnotation;

            protected OfLegacyVmConstructor(Constructor<?> constructor, int index, Class<?> parameterType, Annotation[] parameterAnnotation) {
                this.constructor = constructor;
                this.index = index;
                this.parameterType = parameterType;
                this.parameterAnnotation = parameterAnnotation;
            }

            @Override
            public GenericTypeDescription getType() {
                return new GenericTypeDescription.LazyProjection.OfLoadedParameter.OfLegacyVmConstructor(this.constructor, this.index, this.parameterType);
            }

            @Override
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedConstructor(this.constructor);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public boolean hasModifiers() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotation(this.parameterAnnotation);
            }
        }

        protected static class OfLegacyVmMethod
        extends InDefinedShape.AbstractBase {
            private final Method method;
            private final int index;
            private final Class<?> parameterType;
            private final Annotation[] parameterAnnotation;

            protected OfLegacyVmMethod(Method method, int index, Class<?> parameterType, Annotation[] parameterAnnotation) {
                this.method = method;
                this.index = index;
                this.parameterType = parameterType;
                this.parameterAnnotation = parameterAnnotation;
            }

            @Override
            public GenericTypeDescription getType() {
                return new GenericTypeDescription.LazyProjection.OfLoadedParameter.OfLegacyVmMethod(this.method, this.index, this.parameterType);
            }

            @Override
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedMethod(this.method);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public boolean hasModifiers() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotation(this.parameterAnnotation);
            }
        }

        protected static interface Dispatcher {
            public int getModifiers(Object var1);

            public boolean isNamePresent(Object var1);

            public String getName(Object var1);

            public List<Annotation> getDeclaredAnnotations(Object var1);

            public Object getDeclaringExecutable(Object var1);

            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public int getModifiers(Object parameter) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                @Override
                public boolean isNamePresent(Object parameter) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                @Override
                public String getName(Object parameter) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                @Override
                public List<Annotation> getDeclaredAnnotations(Object parameter) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                @Override
                public Object getDeclaringExecutable(Object parameter) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                public String toString() {
                    return "ParameterDescription.ForLoadedParameter.Dispatcher.ForLegacyVm." + this.name();
                }
            }

            public static class ForModernVm
            implements Dispatcher {
                private final Method getName;
                private final Method getDeclaringExecutable;
                private final Method isNamePresent;
                private final Method getModifiers;
                private final Method getDeclaredAnnotations;

                protected ForModernVm(Method getName, Method getDeclaringExecutable, Method isNamePresent, Method getModifiers, Method getDeclaredAnnotations) {
                    this.getName = getName;
                    this.getDeclaringExecutable = getDeclaringExecutable;
                    this.isNamePresent = isNamePresent;
                    this.getModifiers = getModifiers;
                    this.getDeclaredAnnotations = getDeclaredAnnotations;
                }

                @Override
                public int getModifiers(Object parameter) {
                    try {
                        return (Integer)this.getModifiers.invoke(parameter, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getModifiers", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getModifiers", exception.getCause());
                    }
                }

                @Override
                public boolean isNamePresent(Object parameter) {
                    try {
                        return (Boolean)this.isNamePresent.invoke(parameter, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#isNamePresent", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#isNamePresent", exception.getCause());
                    }
                }

                @Override
                public String getName(Object parameter) {
                    try {
                        return (String)this.getName.invoke(parameter, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getName", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getName", exception.getCause());
                    }
                }

                @Override
                public List<Annotation> getDeclaredAnnotations(Object parameter) {
                    try {
                        return Arrays.asList((Annotation[])this.getDeclaredAnnotations.invoke(parameter, new Object[0]));
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getDeclaredAnnotations", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getDeclaredAnnotations", exception.getCause());
                    }
                }

                @Override
                public Object getDeclaringExecutable(Object parameter) {
                    try {
                        return this.getDeclaringExecutable.invoke(parameter, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getDeclaringExecutable", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getDeclaringExecutable", exception.getCause());
                    }
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForModernVm legal = (ForModernVm)other;
                    return this.getName.equals(legal.getName) && this.getDeclaringExecutable.equals(legal.getDeclaringExecutable) && this.isNamePresent.equals(legal.isNamePresent) && this.getModifiers.equals(legal.getModifiers) && this.getDeclaredAnnotations.equals(legal.getDeclaredAnnotations);
                }

                public int hashCode() {
                    int result = this.getName.hashCode();
                    result = 31 * result + this.getDeclaringExecutable.hashCode();
                    result = 31 * result + this.isNamePresent.hashCode();
                    result = 31 * result + this.getModifiers.hashCode();
                    result = 31 * result + this.getDeclaredAnnotations.hashCode();
                    return result;
                }

                public String toString() {
                    return "ParameterDescription.ForLoadedParameter.Dispatcher.ForModernVm{getName=" + this.getName + ", getDeclaringExecutable=" + this.getDeclaringExecutable + ", isNamePresent=" + this.isNamePresent + ", getModifiers=" + this.getModifiers + ", getDeclaredAnnotations=" + this.getDeclaredAnnotations + '}';
                }
            }
        }
    }

    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements ParameterDescription {
        @Override
        public String getName() {
            return ParameterDescription.NAME_PREFIX.concat(String.valueOf(this.getIndex()));
        }

        @Override
        public String getInternalName() {
            return this.getName();
        }

        @Override
        public String getSourceCodeName() {
            return this.isNamed() ? this.getName() : "";
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        @Override
        public int getOffset() {
            TypeList parameterType = this.getDeclaringMethod().getParameters().asTypeList().asErasures();
            int offset = this.getDeclaringMethod().isStatic() ? StackSize.ZERO.getSize() : StackSize.SINGLE.getSize();
            for (int i = 0; i < this.getIndex(); ++i) {
                offset += ((TypeDescription)parameterType.get(i)).getStackSize().getSize();
            }
            return offset;
        }

        @Override
        public Token asToken() {
            return this.asToken((ElementMatcher)ElementMatchers.none());
        }

        @Override
        public Token asToken(ElementMatcher<? super GenericTypeDescription> targetTypeMatcher) {
            return new Token(this.getType().accept(new GenericTypeDescription.Visitor.Substitutor.ForDetachment(targetTypeMatcher)), this.getDeclaredAnnotations(), this.isNamed() ? this.getName() : Token.NO_NAME, this.hasModifiers() ? Integer.valueOf(this.getModifiers()) : Token.NO_MODIFIERS);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterDescription)) {
                return false;
            }
            ParameterDescription parameterDescription = (ParameterDescription)other;
            return this.getDeclaringMethod().equals(parameterDescription.getDeclaringMethod()) && this.getIndex() == parameterDescription.getIndex();
        }

        public int hashCode() {
            return this.getDeclaringMethod().hashCode() ^ this.getIndex();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Modifier.toString(this.getModifiers()));
            if (this.getModifiers() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.isVarArgs() ? this.getType().asErasure().getName().replaceFirst("\\[\\]$", "...") : this.getType().asErasure().getName());
            return stringBuilder.append(' ').append(this.getName()).toString();
        }
    }

    public static interface InDefinedShape
    extends ParameterDescription {
        @Override
        public MethodDescription.InDefinedShape getDeclaringMethod();

        public static abstract class AbstractBase
        extends net.bytebuddy.description.method.ParameterDescription$AbstractBase
        implements InDefinedShape {
            @Override
            public InDefinedShape asDefined() {
                return this;
            }
        }
    }
}

