/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.sun.tools.javac.tree.EndPosTable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashSet;

public class AppliedFix {
    private final String snippet;
    private final boolean isRemoveLine;

    private AppliedFix(String snippet, boolean isRemoveLine) {
        this.snippet = snippet;
        this.isRemoveLine = isRemoveLine;
    }

    public CharSequence getNewCodeSnippet() {
        return this.snippet;
    }

    public boolean isRemoveLine() {
        return this.isRemoveLine;
    }

    public static Applier fromSource(CharSequence source, EndPosTable endPositions) {
        return new Applier(source, endPositions);
    }

    public static class Applier {
        private final CharSequence source;
        private final EndPosTable endPositions;

        public Applier(CharSequence source, EndPosTable endPositions) {
            this.source = source;
            this.endPositions = endPositions;
        }

        public AppliedFix apply(Fix suggestedFix) {
            StringBuilder replaced = new StringBuilder(this.source);
            HashSet<Integer> modifiedLines = new HashSet<Integer>();
            for (Replacement repl : suggestedFix.getReplacements(this.endPositions)) {
                replaced.replace(repl.startPosition(), repl.endPosition(), repl.replaceWith());
                try {
                    LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(this.source.toString()));
                    lineNumberReader.skip(repl.startPosition());
                    modifiedLines.add(lineNumberReader.getLineNumber());
                }
                catch (IOException lineNumberReader) {}
            }
            if (modifiedLines.isEmpty()) {
                return null;
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(replaced.toString()));
            String snippet = null;
            boolean isRemoveLine = false;
            try {
                while (!modifiedLines.contains(lineNumberReader.getLineNumber())) {
                    lineNumberReader.readLine();
                }
                snippet = lineNumberReader.readLine().trim();
                if (snippet.contains("//")) {
                    snippet = snippet.substring(0, snippet.indexOf("//")).trim();
                }
                if (snippet.isEmpty()) {
                    isRemoveLine = true;
                    snippet = "to remove this line";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new AppliedFix(snippet, isRemoveLine);
        }
    }
}

