/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.util.ArrayList;

@GwtCompatible
public class MultisetForEachEntryTester<E>
extends AbstractMultisetTester<E> {
    public void testForEachEntry() {
        ArrayList expected = new ArrayList(this.getMultiset().entrySet());
        ArrayList actual = new ArrayList();
        this.getMultiset().forEachEntry((element, count) -> actual.add(Multisets.immutableEntry((Object)element, (int)count)));
        Helpers.assertEqualIgnoringOrder(expected, actual);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testForEachEntryOrdered() {
        ArrayList expected = new ArrayList(this.getMultiset().entrySet());
        ArrayList actual = new ArrayList();
        this.getMultiset().forEachEntry((element, count) -> actual.add(Multisets.immutableEntry((Object)element, (int)count)));
        MultisetForEachEntryTester.assertEquals(expected, actual);
    }
}

