/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.sjavac.pubapi.PubApi;
import com.sun.tools.sjavac.pubapi.PubApiTypeParam;
import com.sun.tools.sjavac.pubapi.PubMethod;
import com.sun.tools.sjavac.pubapi.PubType;
import com.sun.tools.sjavac.pubapi.PubVar;
import com.sun.tools.sjavac.pubapi.TypeDesc;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner9;

public class PubapiVisitor
extends ElementScanner9<Void, Void> {
    private PubApi collectedApi = new PubApi();

    private boolean isNonPrivate(Element e) {
        return !e.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    @Override
    public Void visitType(TypeElement e, Void p) {
        if (this.isNonPrivate(e)) {
            PubApi prevApi = this.collectedApi;
            this.collectedApi = new PubApi();
            super.visitType(e, p);
            if (!this.isAnonymous(e)) {
                String name = ((Symbol.ClassSymbol)e).flatname.toString();
                PubType t = new PubType(e.getModifiers(), name, this.collectedApi);
                prevApi.types.put(t.fqName, t);
            }
            this.collectedApi = prevApi;
        }
        return null;
    }

    private boolean isAnonymous(TypeElement e) {
        return e.getQualifiedName().length() == 0;
    }

    private static String encodeChar(int c) {
        return String.format("\\u%04x", c);
    }

    @Override
    public Void visitVariable(VariableElement e, Void p) {
        if (this.isNonPrivate(e)) {
            Object constVal = e.getConstantValue();
            String constValStr = null;
            if (constVal != null) {
                if (e.asType().toString().equals("char")) {
                    char c = constVal.toString().charAt(0);
                    constValStr = "'" + PubapiVisitor.encodeChar(c) + "'";
                } else {
                    constValStr = constVal.toString().chars().mapToObj(PubapiVisitor::encodeChar).collect(Collectors.joining("", "\"", "\""));
                }
            }
            PubVar v = new PubVar(e.getModifiers(), TypeDesc.fromType(e.asType()), e.toString(), constValStr);
            this.collectedApi.variables.put(v.identifier, v);
        }
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Void p) {
        if (this.isNonPrivate(e)) {
            PubMethod m = new PubMethod(e.getModifiers(), this.getTypeParameters(e.getTypeParameters()), TypeDesc.fromType(e.getReturnType()), e.getSimpleName().toString(), this.getTypeDescs(this.getParamTypes(e)), this.getTypeDescs(e.getThrownTypes()));
            this.collectedApi.methods.put(m.asSignatureString(), m);
        }
        return null;
    }

    private List<PubApiTypeParam> getTypeParameters(List<? extends TypeParameterElement> elements) {
        return elements.stream().map(e -> new PubApiTypeParam(e.getSimpleName().toString(), this.getTypeDescs(e.getBounds()))).collect(Collectors.toList());
    }

    private List<TypeMirror> getParamTypes(ExecutableElement e) {
        return e.getParameters().stream().map(Element::asType).collect(Collectors.toList());
    }

    private List<TypeDesc> getTypeDescs(List<? extends TypeMirror> list) {
        return list.stream().map(TypeDesc::fromType).collect(Collectors.toList());
    }

    public PubApi getCollectedPubApi() {
        return this.collectedApi;
    }
}

