/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.parse.ConstExpressionParser;
import com.google.turbine.parse.IteratorLexer;
import com.google.turbine.parse.Lexer;
import com.google.turbine.parse.SavedToken;
import com.google.turbine.parse.StreamLexer;
import com.google.turbine.parse.Token;
import com.google.turbine.parse.UnicodeEscapePreprocessor;
import com.google.turbine.parse.VariableInitializerParser;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineModifier;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class Parser {
    private static final String CTOR_NAME = "<init>";
    private final Lexer lexer;
    private Token token;
    private int position;
    private static final ImmutableSet<TurbineModifier> ENUM_CONSTANT_MODIFIERS = ImmutableSet.of((Object)((Object)TurbineModifier.PUBLIC), (Object)((Object)TurbineModifier.STATIC), (Object)((Object)TurbineModifier.ACC_ENUM), (Object)((Object)TurbineModifier.FINAL));

    public static Tree.CompUnit parse(String source) {
        return Parser.parse(new SourceFile(null, source));
    }

    public static Tree.CompUnit parse(SourceFile source) {
        return new Parser(new StreamLexer(new UnicodeEscapePreprocessor(source))).compilationUnit();
    }

    private Parser(Lexer lexer) {
        this.lexer = lexer;
        this.token = lexer.next();
    }

    public Tree.CompUnit compilationUnit() {
        Optional pkg = Optional.absent();
        EnumSet<TurbineModifier> access = EnumSet.noneOf(TurbineModifier.class);
        ImmutableList.Builder imports = ImmutableList.builder();
        ImmutableList.Builder decls = ImmutableList.builder();
        ImmutableList.Builder annos = ImmutableList.builder();
        block17: while (true) {
            switch (this.token) {
                case PACKAGE: {
                    this.next();
                    pkg = Optional.of((Object)this.packageDeclaration((ImmutableList<Tree.Anno>)annos.build()));
                    annos = ImmutableList.builder();
                    continue block17;
                }
                case IMPORT: {
                    this.next();
                    Tree.ImportDecl i = this.importDeclaration();
                    if (i == null) continue block17;
                    imports.add((Object)i);
                    continue block17;
                }
                case PUBLIC: {
                    this.next();
                    access.add(TurbineModifier.PUBLIC);
                    continue block17;
                }
                case PROTECTED: {
                    this.next();
                    access.add(TurbineModifier.PROTECTED);
                    continue block17;
                }
                case PRIVATE: {
                    this.next();
                    access.add(TurbineModifier.PRIVATE);
                    continue block17;
                }
                case STATIC: {
                    this.next();
                    access.add(TurbineModifier.STATIC);
                    continue block17;
                }
                case ABSTRACT: {
                    this.next();
                    access.add(TurbineModifier.ABSTRACT);
                    continue block17;
                }
                case FINAL: {
                    this.next();
                    access.add(TurbineModifier.FINAL);
                    continue block17;
                }
                case STRICTFP: {
                    this.next();
                    access.add(TurbineModifier.STRICTFP);
                    continue block17;
                }
                case AT: {
                    this.next();
                    if (this.token == Token.INTERFACE) {
                        decls.add((Object)this.annotationDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                        access = EnumSet.noneOf(TurbineModifier.class);
                        annos = ImmutableList.builder();
                        continue block17;
                    }
                    annos.add((Object)this.annotation());
                    continue block17;
                }
                case CLASS: {
                    decls.add((Object)this.classDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block17;
                }
                case INTERFACE: {
                    decls.add((Object)this.interfaceDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block17;
                }
                case ENUM: {
                    decls.add((Object)this.enumDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block17;
                }
                case EOF: {
                    return new Tree.CompUnit(this.position, (Optional<Tree.PkgDecl>)pkg, (ImmutableList<Tree.ImportDecl>)imports.build(), (ImmutableList<Tree.TyDecl>)decls.build(), this.lexer.source());
                }
                case SEMI: {
                    this.next();
                    continue block17;
                }
            }
            break;
        }
        throw this.error(this.token);
    }

    private void next() {
        this.token = this.lexer.next();
        this.position = this.lexer.position();
    }

    private Tree.TyDecl interfaceDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        this.eat(Token.INTERFACE);
        String name = this.eatIdent();
        ImmutableList<Tree.TyParam> typarams = this.token == Token.LT ? this.typarams() : ImmutableList.of();
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.token == Token.EXTENDS) {
            this.next();
            do {
                interfaces.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        this.eat(Token.LBRACE);
        ImmutableList<Tree> members = this.classMembers();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(this.position, access, annos, name, typarams, (Optional<Tree.ClassTy>)Optional.absent(), (ImmutableList<Tree.ClassTy>)interfaces.build(), members, TurbineTyKind.INTERFACE);
    }

    private Tree.TyDecl annotationDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        this.eat(Token.INTERFACE);
        String name = this.eatIdent();
        this.eat(Token.LBRACE);
        ImmutableList<Tree> members = this.classMembers();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(this.position, access, annos, name, (ImmutableList<Tree.TyParam>)ImmutableList.of(), (Optional<Tree.ClassTy>)Optional.absent(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), members, TurbineTyKind.ANNOTATION);
    }

    private Tree.TyDecl enumDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        this.eat(Token.ENUM);
        String name = this.eatIdent();
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.token == Token.IMPLEMENTS) {
            this.next();
            do {
                interfaces.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        this.eat(Token.LBRACE);
        ImmutableList members = ImmutableList.builder().addAll(this.enumMembers(name)).addAll(this.classMembers()).build();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(this.position, access, annos, name, (ImmutableList<Tree.TyParam>)ImmutableList.of(), (Optional<Tree.ClassTy>)Optional.absent(), (ImmutableList<Tree.ClassTy>)interfaces.build(), (ImmutableList<Tree>)members, TurbineTyKind.ENUM);
    }

    private ImmutableList<Tree> enumMembers(String enumName) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableList.Builder annos = ImmutableList.builder();
        block6: while (true) {
            switch (this.token) {
                case IDENT: {
                    String name = this.eatIdent();
                    if (this.token == Token.LPAREN) {
                        this.dropParens();
                    }
                    if (this.token == Token.LBRACE) {
                        this.dropBlocks();
                    }
                    this.maybe(Token.COMMA);
                    result.add((Object)new Tree.VarDecl(this.position, (Set<TurbineModifier>)ENUM_CONSTANT_MODIFIERS, (ImmutableList<Tree.Anno>)annos.build(), new Tree.ClassTy(this.position, (Optional<Tree.ClassTy>)Optional.absent(), enumName, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of()), name, (Optional<Tree.Expression>)Optional.absent()));
                    annos = ImmutableList.builder();
                    continue block6;
                }
                case SEMI: {
                    this.next();
                    annos = ImmutableList.builder();
                    break block6;
                }
                case RBRACE: {
                    annos = ImmutableList.builder();
                    break block6;
                }
                case AT: {
                    this.next();
                    annos.add((Object)this.annotation());
                    continue block6;
                }
                default: {
                    throw this.error(this.token);
                }
            }
            break;
        }
        return result.build();
    }

    private Tree.TyDecl classDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        this.eat(Token.CLASS);
        String name = this.eatIdent();
        ImmutableList<Tree.TyParam> tyParams = ImmutableList.of();
        if (this.token == Token.LT) {
            tyParams = this.typarams();
        }
        Tree.ClassTy xtnds = null;
        if (this.token == Token.EXTENDS) {
            this.next();
            xtnds = this.classty();
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.token == Token.IMPLEMENTS) {
            this.next();
            do {
                interfaces.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        this.eat(Token.LBRACE);
        ImmutableList<Tree> members = this.classMembers();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(this.position, access, annos, name, tyParams, (Optional<Tree.ClassTy>)Optional.fromNullable((Object)xtnds), (ImmutableList<Tree.ClassTy>)interfaces.build(), members, TurbineTyKind.CLASS);
    }

    private ImmutableList<Tree> classMembers() {
        ImmutableList.Builder acc = ImmutableList.builder();
        EnumSet<TurbineModifier> access = EnumSet.noneOf(TurbineModifier.class);
        ImmutableList.Builder annos = ImmutableList.builder();
        block22: while (true) {
            switch (this.token) {
                case PUBLIC: {
                    this.next();
                    access.add(TurbineModifier.PUBLIC);
                    continue block22;
                }
                case PROTECTED: {
                    this.next();
                    access.add(TurbineModifier.PROTECTED);
                    continue block22;
                }
                case PRIVATE: {
                    this.next();
                    access.add(TurbineModifier.PRIVATE);
                    continue block22;
                }
                case STATIC: {
                    this.next();
                    access.add(TurbineModifier.STATIC);
                    continue block22;
                }
                case ABSTRACT: {
                    this.next();
                    access.add(TurbineModifier.ABSTRACT);
                    continue block22;
                }
                case FINAL: {
                    this.next();
                    access.add(TurbineModifier.FINAL);
                    continue block22;
                }
                case NATIVE: {
                    this.next();
                    access.add(TurbineModifier.NATIVE);
                    continue block22;
                }
                case SYNCHRONIZED: {
                    this.next();
                    access.add(TurbineModifier.SYNCHRONIZED);
                    continue block22;
                }
                case TRANSIENT: {
                    this.next();
                    access.add(TurbineModifier.TRANSIENT);
                    continue block22;
                }
                case VOLATILE: {
                    this.next();
                    access.add(TurbineModifier.VOLATILE);
                    continue block22;
                }
                case STRICTFP: {
                    this.next();
                    access.add(TurbineModifier.STRICTFP);
                    continue block22;
                }
                case DEFAULT: {
                    this.next();
                    access.add(TurbineModifier.DEFAULT);
                    continue block22;
                }
                case AT: {
                    this.next();
                    if (this.token == Token.INTERFACE) {
                        acc.add((Object)this.annotationDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                        access = EnumSet.noneOf(TurbineModifier.class);
                        annos = ImmutableList.builder();
                        continue block22;
                    }
                    annos.add((Object)this.annotation());
                    continue block22;
                }
                case IDENT: 
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case VOID: 
                case LT: {
                    acc.addAll(this.classMember(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block22;
                }
                case LBRACE: {
                    this.dropBlocks();
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block22;
                }
                case CLASS: {
                    acc.add((Object)this.classDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block22;
                }
                case INTERFACE: {
                    acc.add((Object)this.interfaceDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block22;
                }
                case ENUM: {
                    acc.add((Object)this.enumDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block22;
                }
                case RBRACE: {
                    return acc.build();
                }
                case SEMI: {
                    this.next();
                    continue block22;
                }
            }
            break;
        }
        throw this.error(this.token);
    }

    private ImmutableList<Tree> classMember(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        ImmutableList<Tree.TyParam> typaram = ImmutableList.of();
        if (this.token == Token.LT) {
            typaram = this.typarams();
        }
        if (this.token == Token.AT) {
            annos = ImmutableList.builder().addAll(annos).addAll(this.maybeAnnos()).build();
        }
        switch (this.token) {
            case VOID: {
                Tree.VoidTy result = new Tree.VoidTy(this.position);
                this.next();
                String name = this.eatIdent();
                return this.memberRest(access, (ImmutableList<Tree.Anno>)annos, typaram, result, name);
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: {
                Tree.Type result = this.referenceType((ImmutableList<Tree.Anno>)ImmutableList.of());
                String name = this.eatIdent();
                return this.memberRest(access, (ImmutableList<Tree.Anno>)annos, typaram, result, name);
            }
            case IDENT: {
                Tree.Type result;
                String ident = this.eatIdent();
                switch (this.token) {
                    case LPAREN: {
                        String name = ident;
                        return ImmutableList.of((Object)this.methodRest(access, (ImmutableList<Tree.Anno>)annos, typaram, null, name));
                    }
                    case IDENT: {
                        Tree.ClassTy result2 = new Tree.ClassTy(this.position, (Optional<Tree.ClassTy>)Optional.absent(), ident, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of());
                        String name = this.eatIdent();
                        return this.memberRest(access, (ImmutableList<Tree.Anno>)annos, typaram, result2, name);
                    }
                    case AT: 
                    case LBRACK: {
                        result = new Tree.ClassTy(this.position, (Optional<Tree.ClassTy>)Optional.absent(), ident, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of());
                        result = this.maybeDims(this.maybeAnnos(), result);
                        break;
                    }
                    case LT: {
                        result = new Tree.ClassTy(this.position, (Optional<Tree.ClassTy>)Optional.absent(), ident, this.tyargs(), (ImmutableList<Tree.Anno>)ImmutableList.of());
                        result = this.maybeDims(this.maybeAnnos(), result);
                        break;
                    }
                    case DOT: {
                        result = new Tree.ClassTy(this.position, (Optional<Tree.ClassTy>)Optional.absent(), ident, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of());
                        break;
                    }
                    default: {
                        throw this.error(this.token);
                    }
                }
                if (result == null) {
                    throw this.error(this.token);
                }
                if (this.token == Token.DOT) {
                    this.next();
                    result = this.classty((Tree.ClassTy)result);
                }
                result = this.maybeDims(this.maybeAnnos(), result);
                String name = this.eatIdent();
                switch (this.token) {
                    case LPAREN: {
                        return ImmutableList.of((Object)this.methodRest(access, (ImmutableList<Tree.Anno>)annos, typaram, result, name));
                    }
                    case SEMI: 
                    case LBRACK: 
                    case ASSIGN: 
                    case COMMA: {
                        if (!typaram.isEmpty()) {
                            throw this.error(TurbineError.ErrorKind.UNEXPECTED_TYPE_PARAMETER, typaram);
                        }
                        return this.fieldRest(access, (ImmutableList<Tree.Anno>)annos, result, name);
                    }
                }
                throw this.error(this.token);
            }
        }
        throw this.error(this.token);
    }

    private ImmutableList<Tree.Anno> maybeAnnos() {
        if (this.token != Token.AT) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        while (this.token == Token.AT) {
            this.next();
            builder.add((Object)this.annotation());
        }
        return builder.build();
    }

    private ImmutableList<Tree> memberRest(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos, ImmutableList<Tree.TyParam> typaram, Tree.Type result, String name) {
        switch (this.token) {
            case SEMI: 
            case LBRACK: 
            case ASSIGN: 
            case COMMA: {
                if (!typaram.isEmpty()) {
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_TYPE_PARAMETER, typaram);
                }
                return this.fieldRest(access, annos, result, name);
            }
            case LPAREN: {
                return ImmutableList.of((Object)this.methodRest(access, annos, typaram, result, name));
            }
        }
        throw this.error(this.token);
    }

    private ImmutableList<Tree> fieldRest(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos, Tree.Type baseTy, String name) {
        ImmutableList.Builder result = ImmutableList.builder();
        VariableInitializerParser initializerParser = new VariableInitializerParser(this.token, this.lexer);
        List<List<SavedToken>> bits = initializerParser.parseInitializers();
        this.token = initializerParser.token;
        boolean first = true;
        for (List<SavedToken> bit : bits) {
            IteratorLexer lexer = new IteratorLexer(this.lexer.source(), bit.iterator());
            Parser parser = new Parser(lexer);
            if (first) {
                first = false;
            } else {
                name = parser.eatIdent();
            }
            Tree.Type ty = baseTy;
            ty = parser.extraDims(ty);
            Tree.Expression init = new ConstExpressionParser(lexer, lexer.next()).expression();
            if (init != null && init.kind() == Tree.Kind.ARRAY_INIT) {
                init = null;
            }
            result.add((Object)new Tree.VarDecl(this.position, access, annos, ty, name, (Optional<Tree.Expression>)Optional.fromNullable((Object)init)));
        }
        this.eat(Token.SEMI);
        return result.build();
    }

    private Tree methodRest(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos, ImmutableList<Tree.TyParam> typaram, Tree.Type result, String name) {
        this.eat(Token.LPAREN);
        ImmutableList.Builder formals = ImmutableList.builder();
        this.formalParams((ImmutableList.Builder<Tree.VarDecl>)formals, access);
        this.eat(Token.RPAREN);
        result = this.extraDims(result);
        ImmutableList.Builder exceptions = ImmutableList.builder();
        if (this.token == Token.THROWS) {
            this.next();
            exceptions.addAll(this.exceptions());
        }
        Tree.Expression defaultValue = null;
        switch (this.token) {
            case SEMI: {
                this.next();
                break;
            }
            case LBRACE: {
                this.dropBlocks();
                break;
            }
            case DEFAULT: {
                ConstExpressionParser cparser = new ConstExpressionParser(this.lexer, this.lexer.next());
                Tree expr = cparser.expression();
                this.token = cparser.token;
                if (expr == null && this.token == Token.AT) {
                    this.next();
                    expr = this.annotation();
                }
                if (expr == null) {
                    throw this.error(this.token);
                }
                defaultValue = expr;
                this.eat(Token.SEMI);
                break;
            }
            default: {
                throw this.error(this.token);
            }
        }
        if (result == null) {
            name = CTOR_NAME;
        }
        return new Tree.MethDecl(this.position, access, annos, typaram, (Optional<Tree>)Optional.fromNullable((Object)result), name, (ImmutableList<Tree.VarDecl>)formals.build(), (ImmutableList<Tree.ClassTy>)exceptions.build(), (Optional<Tree>)Optional.fromNullable(defaultValue));
    }

    private Tree.Type extraDims(Tree.Type ty) {
        ImmutableList<Tree.Anno> annos = this.maybeAnnos();
        if (!annos.isEmpty() && this.token != Token.LBRACK) {
            throw this.error(this.token);
        }
        ArrayDeque<ImmutableList<Tree.Anno>> extra = new ArrayDeque<ImmutableList<Tree.Anno>>();
        while (this.maybe(Token.LBRACK)) {
            this.eat(Token.RBRACK);
            extra.push(annos);
            annos = this.maybeAnnos();
        }
        ty = this.extraDims(ty, extra);
        return ty;
    }

    private Tree.Type extraDims(Tree.Type type, Deque<ImmutableList<Tree.Anno>> extra) {
        if (extra.isEmpty()) {
            return type;
        }
        if (type.kind() == Tree.Kind.ARR_TY) {
            Tree.ArrTy arrTy = (Tree.ArrTy)type;
            return new Tree.ArrTy(arrTy.position(), arrTy.annos(), this.extraDims(arrTy.elem(), extra));
        }
        return new Tree.ArrTy(type.position(), extra.pop(), this.extraDims(type, extra));
    }

    private ImmutableList<Tree.ClassTy> exceptions() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.add((Object)this.classty());
        while (this.maybe(Token.COMMA)) {
            result.add((Object)this.classty());
        }
        return result.build();
    }

    private void formalParams(ImmutableList.Builder<Tree.VarDecl> builder, EnumSet<TurbineModifier> access) {
        while (this.token != Token.RPAREN) {
            Tree.VarDecl formal = this.formalParam();
            builder.add((Object)formal);
            if (formal.mods().contains((Object)TurbineModifier.VARARGS)) {
                access.add(TurbineModifier.VARARGS);
            }
            if (this.token != Token.COMMA) break;
            this.next();
        }
    }

    private Tree.VarDecl formalParam() {
        ImmutableList.Builder annos = ImmutableList.builder();
        EnumSet<TurbineModifier> access = this.modifiersAndAnnotations((ImmutableList.Builder<Tree.Anno>)annos);
        Tree.Type ty = this.referenceType((ImmutableList<Tree.Anno>)ImmutableList.of());
        ImmutableList<Tree.Anno> typeAnnos = this.maybeAnnos();
        if (this.maybe(Token.ELLIPSIS)) {
            access.add(TurbineModifier.VARARGS);
            ty = new Tree.ArrTy(this.position, typeAnnos, ty);
        } else {
            ty = this.maybeDims(typeAnnos, ty);
        }
        String name = this.identOrThis();
        while (this.token == Token.DOT) {
            this.eat(Token.DOT);
            name = this.identOrThis();
        }
        ty = this.extraDims(ty);
        return new Tree.VarDecl(this.position, access, (ImmutableList<Tree.Anno>)annos.build(), ty, name, (Optional<Tree.Expression>)Optional.absent());
    }

    private String identOrThis() {
        switch (this.token) {
            case IDENT: {
                return this.eatIdent();
            }
            case THIS: {
                this.eat(Token.THIS);
                return "this";
            }
        }
        throw this.error(this.token);
    }

    private void dropParens() {
        this.eat(Token.LPAREN);
        int depth = 1;
        while (depth > 0) {
            switch (this.token) {
                case RPAREN: {
                    --depth;
                    break;
                }
                case LPAREN: {
                    ++depth;
                    break;
                }
            }
            this.next();
        }
    }

    private void dropBlocks() {
        this.eat(Token.LBRACE);
        int depth = 1;
        while (depth > 0) {
            switch (this.token) {
                case RBRACE: {
                    --depth;
                    break;
                }
                case LBRACE: {
                    ++depth;
                    break;
                }
            }
            this.next();
        }
    }

    private ImmutableList<Tree.TyParam> typarams() {
        ImmutableList.Builder acc = ImmutableList.builder();
        this.eat(Token.LT);
        block4: while (true) {
            ImmutableList<Tree.Anno> annotations = this.maybeAnnos();
            String name = this.eatIdent();
            ImmutableList<Tree> bounds = ImmutableList.of();
            if (this.token == Token.EXTENDS) {
                this.next();
                bounds = this.tybounds();
            }
            acc.add((Object)new Tree.TyParam(this.position, name, bounds, annotations));
            switch (this.token) {
                case COMMA: {
                    this.eat(Token.COMMA);
                    continue block4;
                }
                case GT: {
                    this.next();
                    break block4;
                }
                default: {
                    throw this.error(this.token);
                }
            }
            break;
        }
        return acc.build();
    }

    private ImmutableList<Tree> tybounds() {
        ImmutableList.Builder acc = ImmutableList.builder();
        do {
            acc.add((Object)this.classty());
        } while (this.maybe(Token.AND));
        return acc.build();
    }

    private Tree.ClassTy classty() {
        return this.classty(null);
    }

    private Tree.ClassTy classty(Tree.ClassTy ty) {
        return this.classty(ty, null);
    }

    private Tree.ClassTy classty(Tree.ClassTy ty, @Nullable ImmutableList<Tree.Anno> typeAnnos) {
        int pos = this.position;
        do {
            if (typeAnnos == null) {
                typeAnnos = this.maybeAnnos();
            }
            String name = this.eatIdent();
            ImmutableList<Tree.Type> tyargs = ImmutableList.of();
            if (this.token == Token.LT) {
                tyargs = this.tyargs();
            }
            ty = new Tree.ClassTy(pos, (Optional<Tree.ClassTy>)Optional.fromNullable((Object)ty), name, tyargs, typeAnnos);
            typeAnnos = null;
        } while (this.maybe(Token.DOT));
        return ty;
    }

    private ImmutableList<Tree.Type> tyargs() {
        ImmutableList.Builder acc = ImmutableList.builder();
        this.eat(Token.LT);
        block15: do {
            ImmutableList<Tree.Anno> typeAnnos = this.maybeAnnos();
            block0 : switch (this.token) {
                case COND: {
                    this.next();
                    switch (this.token) {
                        case EXTENDS: {
                            this.next();
                            Tree.Type upper = this.referenceType(this.maybeAnnos());
                            acc.add((Object)new Tree.WildTy(this.position, typeAnnos, (Optional<Tree.Type>)Optional.of((Object)upper), (Optional<Tree.Type>)Optional.absent()));
                            break block0;
                        }
                        case SUPER: {
                            this.next();
                            Tree.Type lower = this.referenceType(this.maybeAnnos());
                            acc.add((Object)new Tree.WildTy(this.position, typeAnnos, (Optional<Tree.Type>)Optional.absent(), (Optional<Tree.Type>)Optional.of((Object)lower)));
                            break block0;
                        }
                        case COMMA: {
                            acc.add((Object)new Tree.WildTy(this.position, typeAnnos, (Optional<Tree.Type>)Optional.absent(), (Optional<Tree.Type>)Optional.absent()));
                            break block0;
                        }
                        case GT: 
                        case GTGT: 
                        case GTGTGT: {
                            acc.add((Object)new Tree.WildTy(this.position, typeAnnos, (Optional<Tree.Type>)Optional.absent(), (Optional<Tree.Type>)Optional.absent()));
                            break block15;
                        }
                        default: {
                            throw this.error(this.token);
                        }
                    }
                }
                case IDENT: 
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: {
                    acc.add((Object)this.referenceType(typeAnnos));
                    break;
                }
                default: {
                    throw this.error(this.token);
                }
            }
        } while (this.maybe(Token.COMMA));
        switch (this.token) {
            case GT: {
                this.next();
                break;
            }
            case GTGT: {
                this.token = Token.GT;
                break;
            }
            case GTGTGT: {
                this.token = Token.GTGT;
                break;
            }
            default: {
                throw this.error(this.token);
            }
        }
        return acc.build();
    }

    private Tree.Type referenceType(ImmutableList<Tree.Anno> typeAnnos) {
        Tree.Type ty;
        switch (this.token) {
            case IDENT: {
                ty = this.classty(null, typeAnnos);
                break;
            }
            case BOOLEAN: {
                this.next();
                ty = new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.BOOLEAN);
                break;
            }
            case BYTE: {
                this.next();
                ty = new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.BYTE);
                break;
            }
            case SHORT: {
                this.next();
                ty = new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.SHORT);
                break;
            }
            case INT: {
                this.next();
                ty = new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.INT);
                break;
            }
            case LONG: {
                this.next();
                ty = new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.LONG);
                break;
            }
            case CHAR: {
                this.next();
                ty = new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.CHAR);
                break;
            }
            case DOUBLE: {
                this.next();
                ty = new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.DOUBLE);
                break;
            }
            case FLOAT: {
                this.next();
                ty = new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.FLOAT);
                break;
            }
            default: {
                throw this.error(this.token);
            }
        }
        ty = this.maybeDims(this.maybeAnnos(), ty);
        return ty;
    }

    private Tree.Type maybeDims(ImmutableList<Tree.Anno> typeAnnos, Tree.Type ty) {
        while (this.maybe(Token.LBRACK)) {
            this.eat(Token.RBRACK);
            ty = new Tree.ArrTy(this.position, typeAnnos, ty);
            typeAnnos = this.maybeAnnos();
        }
        return ty;
    }

    private EnumSet<TurbineModifier> modifiersAndAnnotations(ImmutableList.Builder<Tree.Anno> annos) {
        EnumSet<TurbineModifier> access = EnumSet.noneOf(TurbineModifier.class);
        block14: while (true) {
            switch (this.token) {
                case PUBLIC: {
                    this.next();
                    access.add(TurbineModifier.PUBLIC);
                    continue block14;
                }
                case PROTECTED: {
                    this.next();
                    access.add(TurbineModifier.PROTECTED);
                    continue block14;
                }
                case PRIVATE: {
                    this.next();
                    access.add(TurbineModifier.PRIVATE);
                    continue block14;
                }
                case STATIC: {
                    this.next();
                    access.add(TurbineModifier.STATIC);
                    continue block14;
                }
                case ABSTRACT: {
                    this.next();
                    access.add(TurbineModifier.ABSTRACT);
                    continue block14;
                }
                case FINAL: {
                    this.next();
                    access.add(TurbineModifier.FINAL);
                    continue block14;
                }
                case NATIVE: {
                    this.next();
                    access.add(TurbineModifier.NATIVE);
                    continue block14;
                }
                case SYNCHRONIZED: {
                    this.next();
                    access.add(TurbineModifier.SYNCHRONIZED);
                    continue block14;
                }
                case TRANSIENT: {
                    this.next();
                    access.add(TurbineModifier.TRANSIENT);
                    continue block14;
                }
                case VOLATILE: {
                    this.next();
                    access.add(TurbineModifier.VOLATILE);
                    continue block14;
                }
                case STRICTFP: {
                    this.next();
                    access.add(TurbineModifier.STRICTFP);
                    continue block14;
                }
                case AT: {
                    this.next();
                    annos.add((Object)this.annotation());
                    continue block14;
                }
            }
            break;
        }
        return access;
    }

    private Tree.ImportDecl importDeclaration() {
        boolean stat = this.maybe(Token.STATIC);
        int pos = this.position;
        ImmutableList.Builder type = ImmutableList.builder();
        type.add((Object)this.eatIdent());
        boolean wild = false;
        block4: while (this.maybe(Token.DOT)) {
            switch (this.token) {
                case IDENT: {
                    type.add((Object)this.eatIdent());
                    continue block4;
                }
                case MULT: {
                    this.eat(Token.MULT);
                    wild = true;
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        this.eat(Token.SEMI);
        return new Tree.ImportDecl(pos, (ImmutableList<String>)type.build(), stat, wild);
    }

    private Tree.PkgDecl packageDeclaration(ImmutableList<Tree.Anno> annos) {
        Tree.PkgDecl result = new Tree.PkgDecl(this.position, this.qualIdent(), annos);
        this.eat(Token.SEMI);
        return result;
    }

    private ImmutableList<String> qualIdent() {
        ImmutableList.Builder name = ImmutableList.builder();
        name.add((Object)this.eatIdent());
        while (this.maybe(Token.DOT)) {
            name.add((Object)this.eatIdent());
        }
        return name.build();
    }

    private Tree.Anno annotation() {
        int pos = this.position;
        ImmutableList<String> name = this.qualIdent();
        ImmutableList.Builder args = ImmutableList.builder();
        if (this.token == Token.LPAREN) {
            this.eat(Token.LPAREN);
            while (this.token != Token.RPAREN) {
                ConstExpressionParser cparser = new ConstExpressionParser(this.lexer, this.token);
                Tree.Expression arg = cparser.expression();
                if (arg == null) {
                    throw this.error(TurbineError.ErrorKind.INVALID_ANNOTATION_ARGUMENT, new Object[0]);
                }
                args.add((Object)arg);
                this.token = cparser.token;
                if (this.maybe(Token.COMMA)) continue;
                break;
            }
            this.eat(Token.RPAREN);
        }
        return new Tree.Anno(pos, name, (ImmutableList<Tree.Expression>)args.build());
    }

    private String eatIdent() {
        String value = this.lexer.stringValue();
        this.eat(Token.IDENT);
        return value;
    }

    private void eat(Token kind) {
        if (this.token != kind) {
            throw this.error(TurbineError.ErrorKind.EXPECTED_TOKEN, new Object[]{kind});
        }
        this.next();
    }

    private boolean maybe(Token kind) {
        if (this.token == kind) {
            this.next();
            return true;
        }
        return false;
    }

    TurbineError error(Token token) {
        switch (token) {
            case IDENT: {
                return this.error(TurbineError.ErrorKind.UNEXPECTED_IDENTIFIER, this.lexer.stringValue());
            }
            case EOF: {
                return this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
            }
        }
        return this.error(TurbineError.ErrorKind.UNEXPECTED_TOKEN, new Object[]{token});
    }

    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.lexer.source(), Math.min(this.lexer.position(), this.lexer.source().source().length() - 1), kind, args);
    }
}

