/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.event.CachePartitionLostEvent;
import com.hazelcast.cache.impl.event.CachePartitionLostEventFilter;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.cache.impl.event.InternalCachePartitionLostListenerAdapter;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.impl.PortableCachePartitionLostEvent;
import java.io.IOException;
import java.security.Permission;

public class CacheAddPartitionLostListenerRequest
extends BaseClientAddListenerRequest {
    private static final EventFilter EVENT_FILTER = new CachePartitionLostEventFilter();
    private String name;

    public CacheAddPartitionLostListenerRequest() {
    }

    public CacheAddPartitionLostListenerRequest(String name) {
        this.name = name;
    }

    public Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        CachePartitionLostListener listener = new CachePartitionLostListener(){

            @Override
            public void partitionLost(CachePartitionLostEvent event) {
                if (endpoint.isAlive()) {
                    PortableCachePartitionLostEvent portableEvent = new PortableCachePartitionLostEvent(event.getPartitionId(), event.getMember().getUuid());
                    endpoint.sendEvent(null, portableEvent, CacheAddPartitionLostListenerRequest.this.getCallId());
                }
            }
        };
        InternalCachePartitionLostListenerAdapter listenerAdapter = new InternalCachePartitionLostListenerAdapter(listener);
        ICacheService service = (ICacheService)this.getService();
        EventService eventService = service.getNodeEngine().getEventService();
        EventRegistration registration = this.localOnly ? eventService.registerLocalListener("hz:impl:cacheService", this.name, EVENT_FILTER, listenerAdapter) : eventService.registerListener("hz:impl:cacheService", this.name, EVENT_FILTER, listenerAdapter);
        String registrationId = registration.getId();
        endpoint.addListenerDestroyAction("hz:impl:cacheService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("name", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("name");
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public String getMethodName() {
        return "addCachePartitionLostListener";
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 26;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

