/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.operation.CacheListenerRegistrationOperation;
import com.hazelcast.client.impl.client.TargetClientRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import javax.cache.configuration.CacheEntryListenerConfiguration;

public class CacheListenerRegistrationRequest
extends TargetClientRequest {
    private String name;
    private CacheEntryListenerConfiguration cacheEntryListenerConfiguration;
    private boolean register;
    private Address target;

    public CacheListenerRegistrationRequest() {
    }

    public CacheListenerRegistrationRequest(String name, CacheEntryListenerConfiguration cacheEntryListenerConfiguration, boolean register, Address target) {
        this.name = name;
        this.cacheEntryListenerConfiguration = cacheEntryListenerConfiguration;
        this.register = register;
        this.target = target;
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 24;
    }

    @Override
    protected Operation prepareOperation() {
        return new CacheListenerRegistrationOperation(this.name, this.cacheEntryListenerConfiguration, this.register);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.operationService.createInvocationBuilder(this.getServiceName(), op, this.target);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("r", this.register);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.cacheEntryListenerConfiguration);
        this.target.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.register = reader.readBoolean("r");
        ObjectDataInput in = reader.getRawDataInput();
        this.cacheEntryListenerConfiguration = (CacheEntryListenerConfiguration)in.readObject();
        this.target = new Address();
        this.target.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(this.name, "listen");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.cacheEntryListenerConfiguration};
    }

    @Override
    public String getMethodName() {
        return "registerCacheEntryListener";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

