/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(name="RectIntersectReturnValueIgnored", summary="Return value of android.graphics.Rect.intersect() must be checked", explanation="`android.graphics.Rect.intersect(Rect r)` and `android.graphics.Rect.intersect(int, int, int, int)` do not always modify the rectangle to the intersected result. If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.\n\nIf you don\u2019t check the return value of these methods, you may end up drawing the wrong rectangle.", category=BugPattern.Category.ANDROID, severity=BugPattern.SeverityLevel.ERROR)
public final class RectIntersectReturnValueIgnored
extends AbstractReturnValueIgnored {
    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return Matchers.instanceMethod().onExactClass("android.graphics.Rect").named("intersect");
    }

    @Override
    public Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        return this.describeMatch(methodInvocationTree);
    }
}

