/*
 *   Copyright 2016 David Edmundson <davidedmundson@kde.org>
 *   Copyright 2016 Luca Giambonini <almack@chakralinux.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2 or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.0
import QtQuick.Layouts 1.1
import QtGraphicalEffects 1.0

import org.kde.plasma.core 2.0
import org.kde.plasma.components 2.0

Item {
    width: clock.implicitWidth
    height: clock.implicitHeight

    DropShadow {
        id: clockShadow
        anchors.fill: clock
        source: clock
        horizontalOffset: 0
        verticalOffset: 2
        radius: 14
        samples: 32
        spread: 0.3
        color: "black"
        opacity: 0.2
    }
    
    ColumnLayout {
        id: clock
        FontLoader {
            source: "artwork/fonts/OpenSans-Light.ttf"
        }
        Label {
            text: Qt.formatTime(timeSource.data["Local"]["DateTime"])
            //font.pointSize: 85
            font { pointSize: 85; family: "OpenSans Light"; weight: Font.Thin}
            Layout.alignment: Qt.AlignHCenter
        }
        Label {
            text: Qt.formatDate(timeSource.data["Local"]["DateTime"], Qt.DefaultLocaleLongDate)
            //font.pointSize: 15
            font { pointSize: 15; family: "OpenSans Light"; weight: Font.Thin}
            Layout.alignment: Qt.AlignHCenter
        }
        DataSource {
            id: timeSource
            engine: "time"
            connectedSources: ["Local"]
            interval: 1000
        }
    }
}
