/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent;

import com.frostwire.bittorrent.BTDownloadItem;
import com.frostwire.bittorrent.BTDownloadListener;
import com.frostwire.bittorrent.BTEngine;
import com.frostwire.bittorrent.BTInfoAdditionalMetadataHolder;
import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.jlibtorrent.AlertListener;
import com.frostwire.jlibtorrent.AnnounceEntry;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.FileStorage;
import com.frostwire.jlibtorrent.PiecesTracker;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.SessionHandle;
import com.frostwire.jlibtorrent.TorrentFlags;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.alerts.Alert;
import com.frostwire.jlibtorrent.alerts.AlertType;
import com.frostwire.jlibtorrent.alerts.PieceFinishedAlert;
import com.frostwire.jlibtorrent.alerts.SaveResumeDataAlert;
import com.frostwire.jlibtorrent.alerts.TorrentAlert;
import com.frostwire.jlibtorrent.swig.add_torrent_params;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.save_resume_data_alert;
import com.frostwire.jlibtorrent.swig.string_entry_map;
import com.frostwire.jlibtorrent.swig.string_vector;
import com.frostwire.jlibtorrent.swig.torrent_flags_t;
import com.frostwire.platform.Platforms;
import com.frostwire.transfers.BittorrentDownload;
import com.frostwire.transfers.TransferItem;
import com.frostwire.transfers.TransferState;
import com.frostwire.util.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class BTDownload
implements BittorrentDownload {
    private static final Logger LOG = Logger.getLogger(BTDownload.class);
    private static final long SAVE_RESUME_RESOLUTION_MILLIS = 10000L;
    private static final int[] ALERT_TYPES = new int[]{AlertType.TORRENT_FINISHED.swig(), AlertType.TORRENT_REMOVED.swig(), AlertType.TORRENT_CHECKED.swig(), AlertType.SAVE_RESUME_DATA.swig(), AlertType.PIECE_FINISHED.swig(), AlertType.STORAGE_MOVED.swig()};
    private static final String EXTRA_DATA_KEY = "extra_data";
    private static final String WAS_PAUSED_EXTRA_KEY = "was_paused";
    private final BTEngine engine;
    private final TorrentHandle th;
    private final File savePath;
    private final Date created;
    private final PiecesTracker piecesTracker;
    private final File parts;
    private final Map<String, String> extra;
    private BTDownloadListener listener;
    private Set<File> incompleteFilesToRemove;
    private long lastSaveResumeTime;
    private final PaymentOptions paymentOptions;
    private final InnerListener innerListener;
    private String predominantFileExtension;

    public BTDownload(BTEngine engine, TorrentHandle th) {
        this.engine = engine;
        this.th = th;
        this.savePath = new File(th.savePath());
        this.created = new Date(th.status().addedTime());
        TorrentInfo ti = th.torrentFile();
        this.piecesTracker = ti != null ? new PiecesTracker(ti) : null;
        this.parts = ti != null ? new File(this.savePath, "." + ti.infoHash() + ".parts") : null;
        this.extra = this.createExtra();
        this.paymentOptions = this.loadPaymentOptions(ti);
        this.innerListener = new InnerListener();
        engine.addListener(this.innerListener);
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    @Override
    public String getName() {
        if (this.th == null) {
            return null;
        }
        return this.th.name();
    }

    @Override
    public String getDisplayName() {
        Priority[] priorities = this.th.filePriorities();
        int count = 0;
        int index = 0;
        for (int i = 0; i < priorities.length; ++i) {
            if (Priority.IGNORE.equals((Object)priorities[i])) continue;
            ++count;
            index = i;
        }
        return count != 1 ? this.th.name() : FilenameUtils.getName(this.th.torrentFile().files().filePath(index));
    }

    @Override
    public long getSize() {
        TorrentInfo ti = this.th.torrentFile();
        return ti != null ? ti.totalSize() : 0L;
    }

    public PaymentOptions getPaymentOptions() {
        return this.paymentOptions;
    }

    @Override
    public boolean isPaused() {
        return this.th.isValid() && (BTDownload.isPaused(this.th.status()) || this.engine.isPaused() || !this.engine.isRunning());
    }

    @Override
    public boolean isSeeding() {
        return this.th.isValid() && this.th.status().isSeeding();
    }

    @Override
    public boolean isFinished() {
        return this.isFinished(false);
    }

    public boolean isFinished(boolean force) {
        return this.th.isValid() && this.th.status(force).isFinished();
    }

    @Override
    public TransferState getState() {
        if (!this.engine.isRunning()) {
            return TransferState.STOPPED;
        }
        if (this.engine.isPaused()) {
            return TransferState.PAUSED;
        }
        if (!this.th.isValid()) {
            return TransferState.ERROR;
        }
        TorrentStatus status = this.th.status();
        boolean isPaused = BTDownload.isPaused(status);
        if (isPaused && status.isFinished()) {
            return TransferState.FINISHED;
        }
        if (isPaused && !status.isFinished()) {
            return TransferState.PAUSED;
        }
        if (!isPaused && status.isFinished()) {
            return TransferState.SEEDING;
        }
        TorrentStatus.State state = status.state();
        switch (state) {
            case CHECKING_FILES: {
                return TransferState.CHECKING;
            }
            case DOWNLOADING_METADATA: {
                return TransferState.DOWNLOADING_METADATA;
            }
            case DOWNLOADING: {
                return TransferState.DOWNLOADING;
            }
            case FINISHED: {
                return TransferState.FINISHED;
            }
            case SEEDING: {
                return TransferState.SEEDING;
            }
            case ALLOCATING: {
                return TransferState.ALLOCATING;
            }
            case CHECKING_RESUME_DATA: {
                return TransferState.CHECKING;
            }
            case UNKNOWN: {
                return TransferState.UNKNOWN;
            }
        }
        return TransferState.UNKNOWN;
    }

    @Override
    public File getSavePath() {
        return this.savePath;
    }

    @Override
    public File previewFile() {
        return null;
    }

    @Override
    public int getProgress() {
        if (this.th == null || !this.th.isValid()) {
            return 0;
        }
        TorrentStatus ts = this.th.status();
        if (ts == null) {
            return 0;
        }
        float fp = ts.progress();
        TorrentStatus.State state = ts.state();
        if (Float.compare(fp, 1.0f) == 0 && state != TorrentStatus.State.CHECKING_FILES) {
            return 100;
        }
        int p = (int)(fp * 100.0f);
        if (p > 0 && state != TorrentStatus.State.CHECKING_FILES) {
            return Math.min(p, 100);
        }
        return 0;
    }

    @Override
    public boolean isComplete() {
        return this.getProgress() == 100;
    }

    @Override
    public long getBytesReceived() {
        return this.th.isValid() ? this.th.status().totalDone() : 0L;
    }

    public long getTotalBytesReceived() {
        return this.th.isValid() ? this.th.status().allTimeDownload() : 0L;
    }

    @Override
    public long getBytesSent() {
        return this.th.isValid() ? this.th.status().totalUpload() : 0L;
    }

    public long getTotalBytesSent() {
        return this.th.isValid() ? this.th.status().allTimeUpload() : 0L;
    }

    @Override
    public long getDownloadSpeed() {
        return !this.th.isValid() || this.isFinished() || this.isPaused() || this.isSeeding() ? 0L : (long)this.th.status().downloadPayloadRate();
    }

    @Override
    public long getUploadSpeed() {
        return !this.th.isValid() || this.isFinished() && !this.isSeeding() || this.isPaused() ? 0L : (long)this.th.status().uploadPayloadRate();
    }

    @Override
    public boolean isDownloading() {
        return this.getDownloadSpeed() > 0L;
    }

    @Override
    public int getConnectedPeers() {
        return this.th.isValid() ? this.th.status().numPeers() : 0;
    }

    public TorrentHandle getTorrentHandle() {
        return this.th;
    }

    @Override
    public int getTotalPeers() {
        return this.th.isValid() ? this.th.status().listPeers() : 0;
    }

    @Override
    public int getConnectedSeeds() {
        return this.th.isValid() ? this.th.status().numSeeds() : 0;
    }

    @Override
    public int getTotalSeeds() {
        return this.th.isValid() ? this.th.status().listSeeds() : 0;
    }

    @Override
    public File getContentSavePath() {
        try {
            if (!this.th.isValid()) {
                return null;
            }
            TorrentInfo ti = this.th.torrentFile();
            if (ti != null && ti.swig() != null) {
                return new File(this.savePath.getAbsolutePath(), ti.numFiles() > 1 ? this.th.name() : ti.files().filePath(0));
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not retrieve download content save path", e);
        }
        return null;
    }

    @Override
    public String getInfoHash() {
        return this.th.infoHash().toString();
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public long getETA() {
        if (!this.th.isValid()) {
            return 0L;
        }
        TorrentInfo ti = this.th.torrentFile();
        if (ti == null) {
            return 0L;
        }
        TorrentStatus status = this.th.status();
        long left = ti.totalSize() - status.totalDone();
        long rate = status.downloadPayloadRate();
        if (left <= 0L) {
            return 0L;
        }
        if (rate <= 0L) {
            return -1L;
        }
        return left / rate;
    }

    @Override
    public void pause() {
        if (!this.th.isValid()) {
            return;
        }
        this.extra.put(WAS_PAUSED_EXTRA_KEY, Boolean.TRUE.toString());
        this.th.unsetFlags(TorrentFlags.AUTO_MANAGED);
        this.th.pause();
        this.doResumeData(true);
    }

    @Override
    public void resume() {
        if (!this.th.isValid()) {
            return;
        }
        this.extra.put(WAS_PAUSED_EXTRA_KEY, Boolean.FALSE.toString());
        this.th.setFlags(TorrentFlags.AUTO_MANAGED);
        this.th.resume();
        this.doResumeData(true);
    }

    public void remove() {
        this.remove(false, false);
    }

    @Override
    public void remove(boolean deleteData) {
        this.remove(false, deleteData);
    }

    @Override
    public void remove(boolean deleteTorrent, boolean deleteData) {
        File torrent;
        String infoHash = this.getInfoHash();
        this.incompleteFilesToRemove = this.getIncompleteFiles();
        if (this.th.isValid()) {
            if (deleteData) {
                this.engine.remove(this.th, SessionHandle.DELETE_FILES);
            } else {
                this.engine.remove(this.th);
            }
        }
        if (deleteTorrent && (torrent = this.engine.readTorrentPath(infoHash)) != null) {
            Platforms.get().fileSystem().delete(torrent);
        }
        this.engine.resumeDataFile(infoHash).delete();
        this.engine.resumeTorrentFile(infoHash).delete();
    }

    @Override
    public String getPredominantFileExtension() {
        TorrentInfo torrentInfo;
        if (this.predominantFileExtension == null && this.th != null && (torrentInfo = this.th.torrentFile()) != null) {
            FileStorage files = torrentInfo.files();
            HashMap<String, Long> extensionByteSums = new HashMap<String, Long>();
            int numFiles = files.numFiles();
            if (files.paths() != null) {
                for (int i = 0; i < numFiles; ++i) {
                    String path = files.filePath(i);
                    String extension = FilenameUtils.getExtension(path);
                    if ("".equals(extension)) continue;
                    if (extensionByteSums.containsKey(extension)) {
                        Long bytes = (Long)extensionByteSums.get(extension);
                        extensionByteSums.put(extension, bytes + files.fileSize(i));
                        continue;
                    }
                    extensionByteSums.put(extension, files.fileSize(i));
                }
                String extensionCandidate = null;
                Set exts = extensionByteSums.keySet();
                for (String ext : exts) {
                    if (extensionCandidate == null) {
                        extensionCandidate = ext;
                        continue;
                    }
                    if ((Long)extensionByteSums.get(ext) <= (Long)extensionByteSums.get(extensionCandidate)) continue;
                    extensionCandidate = ext;
                }
                this.predominantFileExtension = extensionCandidate;
            }
        }
        return this.predominantFileExtension;
    }

    public BTDownloadListener getListener() {
        return this.listener;
    }

    public void setListener(BTDownloadListener listener) {
        this.listener = listener;
    }

    private void torrentFinished() {
        if (this.listener != null) {
            try {
                this.listener.finished(this);
            }
            catch (Throwable e) {
                LOG.error("Error calling listener (finished)", e);
            }
        }
        this.doResumeData(true);
    }

    private void torrentRemoved() {
        this.engine.removeListener(this.innerListener);
        if (this.parts != null) {
            this.parts.delete();
        }
        if (this.listener != null) {
            try {
                this.listener.removed(this, this.incompleteFilesToRemove);
            }
            catch (Throwable e) {
                LOG.error("Error calling listener (removed)", e);
            }
        }
    }

    private void torrentChecked() {
        try {
            if (this.th.isValid()) {
                this.getItems();
            }
        }
        catch (Throwable e) {
            LOG.warn("Error handling torrent checked logic", e);
        }
    }

    private void pieceFinished(PieceFinishedAlert alert2) {
        try {
            if (this.piecesTracker != null) {
                this.piecesTracker.setComplete(alert2.pieceIndex(), true);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error handling piece finished logic", e);
        }
    }

    public boolean isPartial() {
        if (this.th.isValid()) {
            Priority[] priorities;
            for (Priority p : priorities = this.th.filePriorities()) {
                if (!Priority.IGNORE.equals((Object)p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String magnetUri() {
        return this.th.makeMagnetUri();
    }

    public int getDownloadRateLimit() {
        return this.th.getDownloadLimit();
    }

    public void setDownloadRateLimit(int limit) {
        this.th.setDownloadLimit(limit);
    }

    public int getUploadRateLimit() {
        return this.th.getUploadLimit();
    }

    public void setUploadRateLimit(int limit) {
        this.th.setUploadLimit(limit);
    }

    public void requestTrackerAnnounce() {
        this.th.forceReannounce();
    }

    public void requestTrackerScrape() {
        this.th.scrapeTracker();
    }

    public Set<String> trackers() {
        if (!this.th.isValid()) {
            return new HashSet<String>();
        }
        List<AnnounceEntry> trackers = this.th.trackers();
        HashSet<String> urls = new HashSet<String>(trackers.size());
        for (AnnounceEntry e : trackers) {
            urls.add(e.url());
        }
        return urls;
    }

    public void trackers(Set<String> trackers) {
        ArrayList<AnnounceEntry> list = new ArrayList<AnnounceEntry>(trackers.size());
        for (String url : trackers) {
            list.add(new AnnounceEntry(url));
        }
        this.th.replaceTrackers(list);
        this.doResumeData(true);
    }

    @Override
    public List<TransferItem> getItems() {
        TorrentInfo ti;
        ArrayList<TransferItem> items = new ArrayList<TransferItem>();
        if (this.th.isValid() && (ti = this.th.torrentFile()) != null && ti.isValid()) {
            FileStorage fs = ti.files();
            int numFiles = ti.numFiles();
            for (int i = 0; i < numFiles; ++i) {
                BTDownloadItem item = new BTDownloadItem(this.th, i, fs.filePath(i), fs.fileSize(i), this.piecesTracker);
                items.add(item);
            }
            if (this.piecesTracker != null) {
                int numPieces = ti.numPieces();
                for (int i = 0; i < numPieces; ++i) {
                    if (!this.th.havePiece(i)) continue;
                    this.piecesTracker.setComplete(i, true);
                }
            }
        }
        return items;
    }

    public File getTorrentFile() {
        return this.engine.readTorrentPath(this.getInfoHash());
    }

    public Set<File> getIncompleteFiles() {
        HashSet<File> s = new HashSet<File>();
        try {
            if (!this.th.isValid()) {
                return s;
            }
            long[] progress = this.th.fileProgress(TorrentHandle.FileProgressFlags.PIECE_GRANULARITY);
            TorrentInfo ti = this.th.torrentFile();
            if (ti == null) {
                return s;
            }
            FileStorage fs = ti.files();
            String prefix = this.savePath.getAbsolutePath();
            long createdTime = this.created.getTime();
            for (int i = 0; i < progress.length; ++i) {
                File f;
                String fePath = fs.filePath(i);
                long feSize = fs.fileSize(i);
                if (progress[i] >= feSize || !(f = new File(prefix, fePath)).exists() || f.lastModified() < createdTime) continue;
                s.add(f);
            }
        }
        catch (Throwable e) {
            LOG.error("Error calculating the incomplete files set", e);
        }
        return s;
    }

    public boolean isSequentialDownload() {
        if (!this.th.isValid()) {
            return false;
        }
        torrent_flags_t flags = this.th.status().flags();
        return flags.and_(TorrentFlags.SEQUENTIAL_DOWNLOAD).nonZero();
    }

    public void setSequentialDownload(boolean sequential) {
        if (!this.th.isValid()) {
            return;
        }
        if (sequential) {
            this.th.setFlags(TorrentFlags.SEQUENTIAL_DOWNLOAD);
        } else {
            this.th.unsetFlags(TorrentFlags.SEQUENTIAL_DOWNLOAD);
        }
    }

    public File partsFile() {
        return this.parts;
    }

    private PaymentOptions loadPaymentOptions(TorrentInfo ti) {
        try {
            BTInfoAdditionalMetadataHolder holder = new BTInfoAdditionalMetadataHolder(ti, this.getDisplayName());
            return holder.getPaymentOptions();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void serializeResumeData(SaveResumeDataAlert alert2) {
        try {
            if (this.th.isValid()) {
                String infoHash = this.th.infoHash().toString();
                File file = this.engine.resumeDataFile(infoHash);
                entry e = add_torrent_params.write_resume_data(((save_resume_data_alert)alert2.swig()).getParams());
                e.dict().set(EXTRA_DATA_KEY, Entry.fromMap(this.extra).swig());
                FileUtils.writeByteArrayToFile(file, Vectors.byte_vector2bytes(e.bencode()));
            }
        }
        catch (Throwable e) {
            LOG.warn("Error saving resume data", e);
        }
    }

    private void doResumeData(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now - this.lastSaveResumeTime < 10000L) {
            return;
        }
        this.lastSaveResumeTime = now;
        try {
            if (this.th != null && this.th.isValid()) {
                this.th.saveResumeData(TorrentHandle.SAVE_INFO_DICT);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error triggering resume data", e);
        }
    }

    private Map<String, String> createExtra() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            byte[] arr;
            entry e;
            string_entry_map d;
            String infoHash = this.getInfoHash();
            File file = this.engine.resumeDataFile(infoHash);
            if (file.exists() && (d = (e = entry.bdecode(Vectors.bytes2byte_vector(arr = FileUtils.readFileToByteArray(file)))).dict()).has_key(EXTRA_DATA_KEY)) {
                this.readExtra(d.get(EXTRA_DATA_KEY).dict(), map);
            }
        }
        catch (Throwable e) {
            LOG.error("Error reading extra data from resume file", e);
        }
        return map;
    }

    private void readExtra(string_entry_map dict, Map<String, String> map) {
        string_vector keys = dict.keys();
        int size = (int)keys.size();
        for (int i = 0; i < size; ++i) {
            String k = keys.get(i);
            entry e = dict.get(k);
            if (e.type() != entry.data_type.string_t) continue;
            map.put(k, e.string());
        }
    }

    public boolean wasPaused() {
        boolean flag = false;
        if (this.extra.containsKey(WAS_PAUSED_EXTRA_KEY)) {
            try {
                flag = Boolean.parseBoolean(this.extra.get(WAS_PAUSED_EXTRA_KEY));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return flag;
    }

    private static boolean isPaused(TorrentStatus s) {
        return s.flags().and_(TorrentFlags.PAUSED).nonZero();
    }

    private final class InnerListener
    implements AlertListener {
        private InnerListener() {
        }

        @Override
        public int[] types() {
            return ALERT_TYPES;
        }

        @Override
        public void alert(Alert<?> alert2) {
            if (!(alert2 instanceof TorrentAlert)) {
                return;
            }
            if (!((TorrentAlert)alert2).handle().swig().op_eq(BTDownload.this.th.swig())) {
                return;
            }
            AlertType type = alert2.type();
            switch (type) {
                case TORRENT_FINISHED: {
                    BTDownload.this.torrentFinished();
                    break;
                }
                case TORRENT_REMOVED: {
                    BTDownload.this.torrentRemoved();
                    break;
                }
                case TORRENT_CHECKED: {
                    BTDownload.this.torrentChecked();
                    break;
                }
                case SAVE_RESUME_DATA: {
                    BTDownload.this.serializeResumeData((SaveResumeDataAlert)alert2);
                    break;
                }
                case PIECE_FINISHED: {
                    BTDownload.this.pieceFinished((PieceFinishedAlert)alert2);
                    BTDownload.this.doResumeData(false);
                    break;
                }
                case STORAGE_MOVED: {
                    BTDownload.this.doResumeData(true);
                }
            }
        }
    }
}

