/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent;

import com.frostwire.bittorrent.Mappable;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class PaymentOptions
implements Mappable<String, Map<String, String>> {
    public final String bitcoin;
    public final String paypalUrl;
    private String itemName;

    public PaymentOptions() {
        this.bitcoin = null;
        this.paypalUrl = null;
    }

    public PaymentOptions(String bitcoin, String paypal) {
        this.bitcoin = bitcoin;
        this.paypalUrl = paypal;
    }

    public PaymentOptions(Map<String, Entry> paymentOptionsMap) {
        Entry paymentOptions = paymentOptionsMap.get("paymentOptions");
        if (paymentOptions != null) {
            Map<String, Entry> dictionary = paymentOptions.dictionary();
            this.bitcoin = dictionary.containsKey("bitcoin") ? dictionary.get("bitcoin").string() : null;
            this.paypalUrl = dictionary.containsKey("paypalUrl") ? dictionary.get("paypalUrl").string() : null;
        } else {
            this.bitcoin = null;
            this.paypalUrl = null;
        }
    }

    @Override
    public Map<String, Map<String, String>> asMap() {
        HashMap<String, String> innerMap = new HashMap<String, String>();
        if (!StringUtils.isNullOrEmpty(this.bitcoin)) {
            innerMap.put("bitcoin", this.bitcoin);
        }
        if (!StringUtils.isNullOrEmpty(this.paypalUrl)) {
            innerMap.put("paypalUrl", this.paypalUrl);
        }
        HashMap<String, Map<String, String>> paymentOptions = new HashMap<String, Map<String, String>>();
        if (!innerMap.isEmpty()) {
            paymentOptions.put("paymentOptions", innerMap);
        }
        return paymentOptions;
    }

    public void setItemName(String name) {
        this.itemName = name;
    }

    public String getItemName() {
        return this.itemName;
    }

    public boolean isEmpty() {
        return this.bitcoin == null && this.paypalUrl == null;
    }

    public static enum PaymentMethod {
        BITCOIN,
        PAYPAL;

    }
}

