/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.desktop;

import com.frostwire.platform.VPNMonitor;
import com.frostwire.regex.Pattern;
import com.frostwire.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.IOUtils;
import org.limewire.util.OSUtils;

public final class DesktopVPNMonitor
implements VPNMonitor {
    private static final Logger LOG = Logger.getLogger(DesktopVPNMonitor.class);
    private static Pattern PIA_KILL_SWITCH_ROUTE_PATTERN = Pattern.compile(".*?(0\\.0\\.0\\.0).*?(0\\.0\\.0\\.0).*?(10\\.\\d*\\.\\d*\\.\\d*).*(10\\.\\d*\\.\\d*\\.\\d*).*?(\\d\\d)");
    private boolean active = false;

    DesktopVPNMonitor() {
    }

    @Override
    public boolean active() {
        return this.active;
    }

    @Override
    public void refresh() {
        if (OSUtils.isMacOSX() || OSUtils.isLinux()) {
            this.active = this.isPosixVPNActive();
        } else if (OSUtils.isWindows()) {
            this.active = DesktopVPNMonitor.isWindowsVPNActive();
        }
    }

    private boolean isPosixVPNActive() {
        try {
            String[] output;
            for (String line : output = DesktopVPNMonitor.readProcessOutput(DesktopVPNMonitor.netstatCmd(), "-nr").split("\r\n")) {
                if (!line.startsWith("0") || !line.contains("tun")) continue;
                return true;
            }
        }
        catch (Throwable e) {
            LOG.error("Error detecting VPN", e);
        }
        return false;
    }

    private static boolean isWindowsVPNActive() {
        try {
            String[] output;
            for (String line : output = DesktopVPNMonitor.readProcessOutput("netstat", "-nr").split("\r\n")) {
                if (!line.contains("128.0.0.0") && !DesktopVPNMonitor.piaVPNWithKillSwitchOn(line)) continue;
                return true;
            }
        }
        catch (Throwable e) {
            LOG.error("Error detecting VPN", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readProcessOutput(String command, String arguments) {
        String result = "";
        ProcessBuilder pb = new ProcessBuilder(command, arguments);
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            InputStream stdout = process.getInputStream();
            BufferedReader brstdout = new BufferedReader(new InputStreamReader(stdout));
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = brstdout.readLine()) != null) {
                    sb.append(line + "\r\n");
                }
                result = sb.toString();
            }
            catch (Throwable e) {
                LOG.error("Error reading routing table command output", e);
            }
            finally {
                IOUtils.closeQuietly(brstdout);
                IOUtils.closeQuietly(stdout);
            }
        }
        catch (Throwable e) {
            LOG.error("Error executing routing table command", e);
        }
        return result;
    }

    private static boolean piaVPNWithKillSwitchOn(String line) {
        return PIA_KILL_SWITCH_ROUTE_PATTERN.matcher(line).matches();
    }

    private static String netstatCmd() {
        String cmd = "netstat";
        if (OSUtils.isMacOSX() && new File("/usr/sbin/netstat").exists()) {
            cmd = "/usr/sbin/netstat";
        }
        return cmd;
    }
}

