/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadDataLine;
import com.frostwire.gui.bittorrent.BTDownloadModel;
import com.frostwire.gui.filters.TableLineFilter;
import com.frostwire.transfers.TransferState;
import com.limegroup.gnutella.settings.BittorrentSettings;
import java.util.ArrayList;
import java.util.List;

public class BTDownloadRowFilteredModel
extends BTDownloadModel {
    private final TableLineFilter<BTDownloadDataLine> FILTER;
    private final List<BTDownloadDataLine> HIDDEN;

    BTDownloadRowFilteredModel(TableLineFilter<BTDownloadDataLine> f) {
        if (f == null) {
            throw new NullPointerException("null filter");
        }
        this.FILTER = f;
        this.HIDDEN = new ArrayList<BTDownloadDataLine>();
    }

    @Override
    public int add(BTDownloadDataLine tl, int row) {
        if (!this.allow(tl)) {
            this.HIDDEN.add(tl);
            return -1;
        }
        return super.add(tl, row);
    }

    @Override
    public void clear() {
        super.clear();
        this.HIDDEN.clear();
    }

    void filtersChanged() {
        this.rebuild();
        this.fireTableDataChanged();
    }

    private boolean allow(BTDownloadDataLine tl) {
        return this.FILTER.allow(tl);
    }

    private void rebuild() {
        ArrayList existing = new ArrayList(this._list);
        ArrayList<BTDownloadDataLine> hidden = new ArrayList<BTDownloadDataLine>(this.HIDDEN);
        this.clear();
        for (BTDownloadDataLine anExisting : existing) {
            this.addSorted(anExisting);
        }
        for (BTDownloadDataLine tl : hidden) {
            this.addSorted(tl);
        }
    }

    @Override
    public void sort(int col) {
        super.sort(col);
        this.saveSortSettings();
    }

    @Override
    public void unsort() {
        super.unsort();
        this.saveSortSettings();
    }

    private void saveSortSettings() {
        BittorrentSettings.BTMEDIATOR_COLUMN_SORT_INDEX.setValue(this.getSortColumn());
        BittorrentSettings.BTMEDIATOR_COLUMN_SORT_ORDER.setValue(this.isSortAscending());
    }

    @Override
    int getActiveUploads() {
        int count = super.getActiveUploads();
        try {
            for (BTDownloadDataLine aHIDDEN : this.HIDDEN) {
                BTDownload downloader = (BTDownload)aHIDDEN.getInitializeObject();
                if (!downloader.isCompleted() || downloader.getState() != TransferState.SEEDING) continue;
                ++count;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return count;
    }
}

