/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.bittorrent.CopyrightLicenseBroker;
import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.PartialFilesDialog;
import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.jlibtorrent.FileStorage;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.swig.add_torrent_params;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.tcp_endpoint_vector;
import com.frostwire.search.PerformersHelper;
import com.frostwire.transfers.TransferState;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.UrlUtils;
import com.frostwire.util.UserAgentGenerator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.VPNDropGuard;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TorrentFetcherDownload
implements BTDownload {
    private static final Logger LOG = Logger.getLogger(TorrentFetcherDownload.class);
    private final String uri;
    private final String referer;
    private final String cookie;
    private final String displayName;
    private final boolean partial;
    private final String relativePath;
    private final String hash;
    private final Date dateCreated;
    private TransferState state;

    public TorrentFetcherDownload(String uri, String referrer, String cookie, String displayName, boolean partial, String relativePath) {
        this.uri = uri;
        this.hash = uri.startsWith("magnet") ? PerformersHelper.parseInfoHash(uri) : "";
        this.referer = referrer;
        this.cookie = cookie;
        this.displayName = displayName;
        this.partial = partial;
        this.relativePath = !partial ? relativePath : null;
        this.dateCreated = new Date();
        this.state = TransferState.DOWNLOADING_TORRENT;
        Thread t = new Thread((Runnable)new FetcherRunnable(), "Torrent-Fetcher - " + uri);
        t.setDaemon(true);
        t.start();
    }

    public TorrentFetcherDownload(String uri, String referrer, String displayName, boolean partial, String relativePath) {
        this(uri, referrer, null, displayName, partial, relativePath);
    }

    public TorrentFetcherDownload(String uri, String referrer, String displayName, boolean partial) {
        this(uri, referrer, displayName, partial, null);
    }

    public TorrentFetcherDownload(String uri, boolean partial) {
        this(uri, null, TorrentFetcherDownload.getDownloadNameFromMagnetURI(uri), partial);
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isResumable() {
        return false;
    }

    @Override
    public boolean isPausable() {
        return false;
    }

    @Override
    public boolean isCompleted() {
        return false;
    }

    @Override
    public TransferState getState() {
        return this.state;
    }

    @Override
    public void remove() {
        this.state = TransferState.CANCELED;
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public File getSaveLocation() {
        return null;
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public long getBytesReceived() {
        return 0L;
    }

    @Override
    public long getBytesSent() {
        return 0L;
    }

    @Override
    public double getDownloadSpeed() {
        return 0.0;
    }

    @Override
    public double getUploadSpeed() {
        return 0.0;
    }

    @Override
    public long getETA() {
        return 0L;
    }

    @Override
    public String getPeersString() {
        return "";
    }

    @Override
    public String getSeedsString() {
        return "";
    }

    public boolean isDeleteTorrentWhenRemove() {
        return false;
    }

    @Override
    public void setDeleteTorrentWhenRemove(boolean deleteTorrentWhenRemove) {
    }

    public boolean isDeleteDataWhenRemove() {
        return false;
    }

    @Override
    public void setDeleteDataWhenRemove(boolean deleteDataWhenRemove) {
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getSeedToPeerRatio() {
        return "";
    }

    @Override
    public String getShareRatio() {
        return "";
    }

    @Override
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public boolean isPartialDownload() {
        return false;
    }

    public long getSize(boolean update) {
        return -1L;
    }

    @Override
    public PaymentOptions getPaymentOptions() {
        return null;
    }

    @Override
    public CopyrightLicenseBroker getCopyrightLicenseBroker() {
        return null;
    }

    @Override
    public boolean canPreview() {
        return false;
    }

    @Override
    public File getPreviewFile() {
        return null;
    }

    private void cancel() {
        this.state = TransferState.CANCELED;
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                BTDownloadMediator.instance().remove(TorrentFetcherDownload.this);
            }
        });
    }

    private void downloadTorrent(final byte[] data, final List<TcpEndpoint> peers) {
        if (VPNDropGuard.canUseBitTorrent()) {
            if (this.relativePath != null) {
                try {
                    TorrentInfo ti = TorrentInfo.bdecode(data);
                    boolean[] selection = this.calculateSelection(ti, this.relativePath);
                    BTEngine.getInstance().download(ti, null, selection, peers);
                }
                catch (Throwable e) {
                    LOG.error("Error downloading torrent", e);
                }
            } else {
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean[] selection = null;
                            if (TorrentFetcherDownload.this.partial) {
                                PartialFilesDialog dlg = new PartialFilesDialog(GUIMediator.getAppFrame(), data, TorrentFetcherDownload.this.displayName);
                                dlg.setVisible(true);
                                selection = dlg.getFilesSelection();
                                if (selection == null) {
                                    return;
                                }
                            }
                            TorrentInfo ti = TorrentInfo.bdecode(data);
                            BTEngine.getInstance().download(ti, null, selection, peers);
                            GUIMediator.instance().showTransfers(TransfersTab.FilterMode.ALL);
                        }
                        catch (Throwable e) {
                            LOG.error("Error downloading torrent", e);
                        }
                    }
                });
            }
        }
    }

    private boolean[] calculateSelection(TorrentInfo ti, String path) {
        boolean[] selection = new boolean[ti.numFiles()];
        FileStorage fs = ti.files();
        for (int i = 0; i < selection.length; ++i) {
            String filePath = fs.filePath(i);
            if (!path.endsWith(filePath) && !filePath.endsWith(path)) continue;
            selection[i] = true;
        }
        return selection;
    }

    private static String getDownloadNameFromMagnetURI(String uri) {
        if (!uri.startsWith("magnet:")) {
            return uri;
        }
        if (uri.contains("dn=")) {
            String[] split;
            for (String s : split = uri.split("&")) {
                if (!s.toLowerCase().startsWith("dn=") || s.length() <= 3) continue;
                return UrlUtils.decode(s.split("=")[1]);
            }
        }
        return uri;
    }

    private static List<TcpEndpoint> parsePeers(String magnet) {
        if (magnet == null || magnet.isEmpty() || magnet.startsWith("http")) {
            return Collections.emptyList();
        }
        error_code ec = new error_code();
        add_torrent_params params = add_torrent_params.parse_magnet_uri(magnet, ec);
        tcp_endpoint_vector v = params.get_peers();
        int size = (int)v.size();
        ArrayList<TcpEndpoint> l = new ArrayList<TcpEndpoint>();
        for (int i = 0; i < size; ++i) {
            l.add(new TcpEndpoint(v.get(i)));
        }
        return l;
    }

    private class FetcherRunnable
    implements Runnable {
        private FetcherRunnable() {
        }

        @Override
        public void run() {
            block8: {
                if (TorrentFetcherDownload.this.state == TransferState.CANCELED) {
                    return;
                }
                try {
                    byte[] data = TorrentFetcherDownload.this.uri.startsWith("http") ? HttpClientFactory.getInstance(HttpClientFactory.HttpContext.DOWNLOAD).getBytes(TorrentFetcherDownload.this.uri, 15000, UserAgentGenerator.getUserAgent(), TorrentFetcherDownload.this.referer, TorrentFetcherDownload.this.cookie) : BTEngine.getInstance().fetchMagnet(TorrentFetcherDownload.this.uri, 90, true);
                    if (TorrentFetcherDownload.this.state == TransferState.CANCELED) {
                        return;
                    }
                    if (data != null) {
                        try {
                            TorrentFetcherDownload.this.downloadTorrent(data, TorrentFetcherDownload.parsePeers(TorrentFetcherDownload.this.uri));
                            break block8;
                        }
                        finally {
                            TorrentFetcherDownload.this.cancel();
                        }
                    }
                    TorrentFetcherDownload.this.state = TransferState.ERROR_NOT_ENOUGH_PEERS;
                }
                catch (Throwable e) {
                    TorrentFetcherDownload.this.state = TransferState.ERROR;
                    LOG.error("Error downloading torrent from uri", e);
                }
            }
        }
    }
}

