/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.AlphaIcon;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.TransferHolder;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.transfers.TransferState;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.FWAbstractJPanelTableCellRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public final class TransferActionsRenderer
extends FWAbstractJPanelTableCellRenderer {
    private static final ImageIcon play_solid = GUIMediator.getThemeImage("search_result_play_over");
    private static final AlphaIcon play_transparent = new AlphaIcon(play_solid, 0.1f);
    private static final ImageIcon share_solid = GUIMediator.getThemeImage("transfers_sharing_over");
    private static final AlphaIcon share_faded = new AlphaIcon(share_solid, 0.1f);
    private JLabel labelPlay;
    private JLabel labelShare;
    private BTDownload dl;

    public TransferActionsRenderer() {
        this.setupUI();
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = -1;
        c.ipadx = 3;
        c.insets = new Insets(2, 5, 2, 5);
        this.labelShare = new JLabel(share_solid);
        this.labelShare.setToolTipText(I18n.tr("SHARE the download url/magnet of this seeding transfer"));
        this.labelShare.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (TransferActionsRenderer.this.dl.getState().equals((Object)TransferState.DOWNLOADING)) {
                        return;
                    }
                    BittorrentDownload.RendererHelper.onSeedTransfer(TransferActionsRenderer.this.dl, true);
                }
            }
        });
        this.add((Component)this.labelShare, c);
        this.labelPlay = new JLabel(play_transparent);
        this.labelPlay.setToolTipText(I18n.tr("Play/Preview"));
        this.labelPlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    TransferActionsRenderer.this.onPlay();
                }
            }
        });
        this.add((Component)this.labelPlay, c);
        this.setEnabled(true);
    }

    @Override
    protected void updateUIData(Object dataHolder, JTable table, int row, int column) {
        this.updateUIData((TransferHolder)dataHolder, table, row, column);
    }

    private void updateUIData(TransferHolder actionsHolder, JTable table, int row, int column) {
        this.dl = actionsHolder.getDl();
        boolean canShareNow = BittorrentDownload.RendererHelper.canShareNow(this.dl);
        this.labelShare.setIcon(canShareNow ? share_solid : share_faded);
        this.updatePlayButton();
    }

    private void updatePlayButton() {
        boolean playable = this.dl.canPreview();
        this.labelPlay.setIcon(this.isDlBeingPlayed() ? GUIMediator.getThemeImage("speaker") : (playable ? play_solid : play_transparent));
    }

    private void onPlay() {
        if (this.dl.canPreview() && !this.isDlBeingPlayed()) {
            File file = this.dl.getPreviewFile();
            if (file != null) {
                GUIMediator.instance().launchMedia(new MediaSource(file), !this.dl.isCompleted());
            }
            this.updatePlayButton();
        }
    }

    private boolean isDlBeingPlayed() {
        File file = this.dl.getPreviewFile();
        return file != null && MediaPlayer.instance().isThisBeingPlayed(this.dl.getPreviewFile());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.updatePlayButton();
    }
}

