/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.slides;

import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.limewire.concurrent.ThreadExecutor;

public class ImageCache {
    private static final Logger LOG = Logger.getLogger(ImageCache.class);
    private static ImageCache instance;

    public static synchronized ImageCache instance() {
        if (instance == null) {
            instance = new ImageCache();
        }
        return instance;
    }

    private ImageCache() {
    }

    public BufferedImage getImage(URL url, OnLoadedListener listener) {
        if (this.isCached(url)) {
            return this.loadFromCache(url, listener);
        }
        if (!url.getProtocol().equals("http")) {
            return this.loadFromResource(url, listener);
        }
        this.loadFromUrl(url, listener);
        return null;
    }

    private File getCacheFile(URL url) {
        String host = url.getHost();
        String path = url.getPath();
        if (host == null || host.length() == 0) {
            host = "localhost";
            path = new File(path).getName();
        }
        return new File(SharingSettings.getImageCacheDirectory(), File.separator + host + File.separator + path);
    }

    public URL getCachedFileURL(URL remoteURL) {
        if (this.isCached(remoteURL)) {
            try {
                return this.getCacheFile(remoteURL).toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    private boolean isCached(URL url) {
        File file = this.getCacheFile(url);
        return file.exists();
    }

    private BufferedImage loadFromCache(URL url, OnLoadedListener listener) {
        try {
            File file = this.getCacheFile(url);
            BufferedImage image = ImageIO.read(file);
            listener.onLoaded(url, image, true, false);
            return image;
        }
        catch (Throwable e) {
            LOG.error("Failed to load image from cache: " + url, e);
            if (e instanceof OutOfMemoryError) {
                e.printStackTrace();
            }
            listener.onLoaded(url, null, false, true);
            return null;
        }
    }

    private BufferedImage loadFromResource(URL url, OnLoadedListener listener) {
        try {
            BufferedImage image = ImageIO.read(url);
            this.saveToCache(url, image, 0L);
            listener.onLoaded(url, image, false, false);
            return image;
        }
        catch (Throwable e) {
            LOG.error("Failed to load image from resource: " + url, e);
            listener.onLoaded(url, null, false, true);
            return null;
        }
    }

    private void loadFromUrl(final URL url, final OnLoadedListener listener) {
        ThreadExecutor.startThread(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedImage image = null;
                    HttpClient newInstance = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
                    byte[] data = newInstance.getBytes(url.toString());
                    if (data == null) {
                        throw new IOException("ImageCache.loadUrl() got nothing at " + url.toString());
                    }
                    if (data != null) {
                        image = ImageIO.read(new ByteArrayInputStream(data));
                        ImageCache.this.saveToCache(url, image, System.currentTimeMillis());
                    }
                    if (listener != null && image != null) {
                        listener.onLoaded(url, image, false, false);
                    }
                }
                catch (Throwable e) {
                    LOG.error("Failed to load image from: " + url, e);
                    listener.onLoaded(url, null, false, true);
                }
            }
        }), "ImageCache.loadFromUrl");
    }

    private void saveToCache(URL url, BufferedImage image, long date) {
        try {
            File file = this.getCacheFile(url);
            if (file.exists()) {
                file.delete();
            }
            String filename = file.getName();
            int dotIndex = filename.lastIndexOf(46);
            String ext = filename.substring(dotIndex + 1);
            String formatName = ImageIO.getImageReadersBySuffix(ext).next().getFormatName();
            if (!file.getParentFile().exists()) {
                file.mkdirs();
            }
            ImageIO.write((RenderedImage)image, formatName, file);
            file.setLastModified(date);
        }
        catch (Throwable e) {
            LOG.error("Failed to save image to cache: " + url, e);
        }
    }

    public static interface OnLoadedListener {
        public void onLoaded(URL var1, BufferedImage var2, boolean var3, boolean var4);
    }
}

