/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.slides;

import com.frostwire.gui.components.slides.ImageCache;
import com.frostwire.gui.components.slides.Slide;
import com.frostwire.gui.components.slides.SlideControlsOverlay;
import com.frostwire.gui.components.slides.SlidePanelController;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

class SlidePanel
extends JPanel {
    private final int index;
    private JLabel imageLabel;
    private final SlidePanelController controller;
    private SlideControlsOverlay overlayControls;

    public SlidePanel(Slide slide, int index) {
        this.index = index;
        this.controller = new SlidePanelController(slide);
        this.setupUI();
    }

    private void setupUI() {
        this.setLayout(new BorderLayout());
        this.setupImageArea();
    }

    private void setupImageArea() {
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setMinimumSize(new Dimension(717, 380));
        layeredPane.setPreferredSize(new Dimension(717, 380));
        layeredPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SlidePanel.this.overlayControls.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!SlidePanel.this.imageLabel.getBounds().contains(e.getPoint())) {
                    SlidePanel.this.overlayControls.setVisible(false);
                }
            }
        });
        this.imageLabel = new JLabel();
        this.overlayControls = new SlideControlsOverlay(this.controller);
        this.overlayControls.setVisible(false);
        if (this.controller.getSlide().method != 0) {
            layeredPane.add((Component)this.overlayControls, new Integer(1));
        } else {
            this.imageLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (((SlidePanel)SlidePanel.this).controller.getSlide().method == 0) {
                        SlidePanel.this.controller.downloadSlide();
                    }
                }
            });
        }
        layeredPane.add((Component)this.imageLabel, new Integer(0));
        this.add((Component)layeredPane, "Center");
        try {
            ImageCache.instance().getImage(new URL(this.controller.getSlide().imageSrc), new ImageCache.OnLoadedListener(){

                @Override
                public void onLoaded(URL url, final BufferedImage image, boolean fromCache, boolean fail) {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (image != null) {
                                SlidePanel.this.imageLabel.setIcon(new ImageIcon(image));
                                SlidePanel.this.imageLabel.setBounds(0, 0, image.getWidth(), image.getHeight());
                                SlidePanel.this.overlayControls.setBounds(0, 0, image.getWidth(), image.getHeight());
                            }
                        }
                    });
                }
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isOverlayVisible() {
        return this.overlayControls.isVisible();
    }

    public Slide getSlide() {
        return this.controller.getSlide();
    }
}

