/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.components.transfers.TransferDetailComponent;
import com.frostwire.gui.components.transfers.TransferDetailFilesTableMediator;
import com.frostwire.transfers.TransferItem;
import com.frostwire.util.Logger;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public final class TransferDetailFiles
extends JPanel
implements TransferDetailComponent.TransferDetailPanel {
    private static final Logger LOG = Logger.getLogger(TransferDetailFiles.class);
    private final TransferDetailFilesTableMediator tableMediator = new TransferDetailFilesTableMediator();
    private BittorrentDownload btDownload;

    TransferDetailFiles() {
        this.setLayout(new MigLayout("fillx, insets 0 0 0 0"));
        this.add((Component)this.tableMediator.getComponent(), "gap 0 0 0 0, growx, growy");
    }

    @Override
    public void updateData(BittorrentDownload btDownload) {
        if (btDownload != null && btDownload.getDl() != null) {
            try {
                List<TransferItem> items = btDownload.getDl().getItems();
                if (items != null && items.size() > 0) {
                    if (this.btDownload != btDownload) {
                        this.btDownload = btDownload;
                        this.tableMediator.clearTable();
                        int i = 0;
                        for (TransferItem item : items) {
                            this.tableMediator.add(new TransferItemHolder(i++, item));
                        }
                    } else {
                        int i = 0;
                        for (TransferItem item : items) {
                            this.tableMediator.update(new TransferItemHolder(i++, item));
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOG.error("Error updating transfer files details", e);
            }
        }
    }

    public class TransferItemHolder {
        final int fileOffset;
        public final TransferItem transferItem;

        TransferItemHolder(int fileOffset, TransferItem transferItem) {
            this.fileOffset = fileOffset;
            this.transferItem = transferItem;
        }

        public int hashCode() {
            return this.fileOffset;
        }

        public boolean equals(Object obj) {
            return obj instanceof TransferItemHolder && ((TransferItemHolder)obj).fileOffset == this.fileOffset;
        }
    }
}

