/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylists;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListModel;

public class LibraryIconList
extends JList<Object> {
    private Image speaker;
    private Image loading;

    public LibraryIconList() {
        this.loadIcons();
    }

    public LibraryIconList(ListModel<Object> dataModel) {
        super(dataModel);
        this.loadIcons();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int index;
        super.paintComponent(g);
        MediaPlayer player = MediaPlayer.instance();
        if (player.getState() != MediaPlaybackState.Stopped && player.getState() != MediaPlaybackState.Closed && player.getState() != MediaPlaybackState.Failed && player.getCurrentMedia() != null && player.getCurrentPlaylist() != null && player.getPlaylistFilesView() != null && (index = this.getPlaylistIndex(player.getCurrentPlaylist())) != -1) {
            this.paintIcon(g, this.speaker, index);
        }
        this.paintImportingIcons(g);
    }

    private void loadIcons() {
        this.speaker = GUIMediator.getThemeImage("speaker").getImage();
        this.loading = GUIMediator.getThemeImage("indeterminate_small_progress").getImage();
    }

    private void paintIcon(Graphics g, Image image, int index) {
        Rectangle rect = this.getUI().getCellBounds(this, index, index);
        Dimension lsize = rect.getSize();
        Point llocation = rect.getLocation();
        g.drawImage(image, llocation.x + lsize.width - this.speaker.getWidth(null) - 4, llocation.y + (lsize.height - this.speaker.getHeight(null)) / 2, null);
    }

    private int getPlaylistIndex(Playlist playlist) {
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Playlist p;
            Object value = this.getModel().getElementAt(i);
            if (!(value instanceof LibraryPlaylists.LibraryPlaylistsListCell) || (p = ((LibraryPlaylists.LibraryPlaylistsListCell)value).getPlaylist()) == null || !p.equals(playlist)) continue;
            return i;
        }
        return -1;
    }

    private void paintImportingIcons(Graphics g) {
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Object value = this.getModel().getElementAt(i);
            if (value instanceof LibraryPlaylists.LibraryPlaylistsListCell) {
                Playlist p = ((LibraryPlaylists.LibraryPlaylistsListCell)value).getPlaylist();
                if (!LibraryMediator.instance().getLibraryPlaylists().isPlaylistImporting(p)) continue;
                this.paintIcon(g, this.loading, i);
                continue;
            }
            return;
        }
    }
}

