/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.DirectoryHolderNode;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.StarredDirectoryHolder;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibraryIconTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(LibraryIconTree.class.getName());
    private Image speaker;

    public LibraryIconTree() {
        this.loadIcons();
    }

    public LibraryIconTree(TreeModel dataModel) {
        super(dataModel);
        this.loadIcons();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            MediaPlayer player = MediaPlayer.instance();
            MediaPlaybackState playerState = player.getState();
            if (playerState != MediaPlaybackState.Stopped && playerState != MediaPlaybackState.Closed && playerState != MediaPlaybackState.Failed) {
                TreePath path;
                if (player.getCurrentMedia() != null && player.getCurrentPlaylist() == null && player.getPlaylistFilesView() != null) {
                    TreePath path2 = this.getAudioPath();
                    if (path2 != null) {
                        this.paintIcon(g, this.speaker, path2);
                    }
                } else if (player.getCurrentMedia() != null && player.getCurrentPlaylist() != null && player.getPlaylistFilesView() != null && (path = this.getPlaylistPath(player.getCurrentPlaylist())) != null) {
                    this.paintIcon(g, this.speaker, path);
                }
            }
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "Error painting the speaker icon", e);
        }
    }

    private void loadIcons() {
        this.speaker = GUIMediator.getThemeImage("speaker").getImage();
    }

    private void paintIcon(Graphics g, Image image, TreePath path) {
        Rectangle rect = this.getUI().getPathBounds(this, path);
        if (rect != null) {
            Dimension lsize = rect.getSize();
            Point llocation = rect.getLocation();
            g.drawImage(image, llocation.x + this.getWidth() - this.speaker.getWidth(null) - 4, llocation.y + (lsize.height - this.speaker.getHeight(null)) / 2, null);
        }
    }

    private TreePath getAudioPath() {
        Enumeration<TreeNode> e = ((LibraryNode)this.getModel().getRoot()).depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DirectoryHolder holder;
            LibraryNode node = (LibraryNode)e.nextElement();
            if (!(node instanceof DirectoryHolderNode) || !((holder = ((DirectoryHolderNode)node).getDirectoryHolder()) instanceof MediaTypeSavedFilesDirectoryHolder) || !((MediaTypeSavedFilesDirectoryHolder)holder).getMediaType().equals(MediaType.getAudioMediaType())) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    private TreePath getPlaylistPath(Playlist playlist) {
        if (playlist.getId() == -3) {
            Enumeration<TreeNode> e = ((LibraryNode)this.getModel().getRoot()).depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DirectoryHolder holder;
                LibraryNode node = (LibraryNode)e.nextElement();
                if (!(node instanceof DirectoryHolderNode) || !((holder = ((DirectoryHolderNode)node).getDirectoryHolder()) instanceof StarredDirectoryHolder)) continue;
                return new TreePath(node.getPath());
            }
        }
        return null;
    }
}

