/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableModel;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferable;
import com.frostwire.gui.library.LibraryUtils;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

class LibraryPlaylistsTableTransferHandler
extends TransferHandler {
    private final LibraryPlaylistsTableMediator mediator;
    private final TransferHandler fallbackTransferHandler;

    LibraryPlaylistsTableTransferHandler(LibraryPlaylistsTableMediator mediator) {
        this.mediator = mediator;
        this.fallbackTransferHandler = new MulticastTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLERS);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return this.canImport(support, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        block12: {
            if (!this.canImport(support, false)) {
                return this.fallbackTransferHandler.importData(support);
            }
            JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
            int index = dl.getRow();
            try {
                Transferable transferable;
                if (support.isDataFlavorSupported(LibraryPlaylistsTableTransferable.PLAYLIST_ITEM_ARRAY)) {
                    Transferable transferable2 = support.getTransferable();
                    try {
                        LibraryPlaylistsTableTransferable.PlaylistItemContainer container = (LibraryPlaylistsTableTransferable.PlaylistItemContainer)transferable2.getTransferData(LibraryPlaylistsTableTransferable.PLAYLIST_ITEM_ARRAY);
                        LibraryUtils.movePlaylistItemsToIndex(this.mediator.getCurrentPlaylist(), container.selectedIndexes, index);
                    }
                    finally {
                        return false;
                    }
                }
                int max = this.mediator.getTable().getModel().getRowCount();
                if (index < 0 || index > max) {
                    index = max;
                }
                if (DNDUtils.contains((transferable = support.getTransferable()).getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                    if (this.mediator.getCurrentPlaylist() != null) {
                        this.importPlaylistItemArrayData(transferable, index);
                    }
                    break block12;
                }
                if (this.mediator.getCurrentPlaylist() == null) {
                }
                File[] files = DNDUtils.getFiles(support.getTransferable());
                if (files.length == 1 && files[0].getAbsolutePath().endsWith(".m3u")) {
                    LibraryUtils.asyncAddToPlaylist(this.mediator.getCurrentPlaylist(), files[0], index);
                }
                LibraryUtils.asyncAddToPlaylist(this.mediator.getCurrentPlaylist(), files, index);
            }
            catch (Throwable e) {
                return this.fallbackTransferHandler.importData(support);
            }
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000003;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        List lines = this.mediator.getSelectedLines();
        ArrayList<PlaylistItem> playlistItems = new ArrayList<PlaylistItem>(lines.size());
        for (AbstractLibraryTableDataLine line : lines) {
            playlistItems.add((PlaylistItem)line.getInitializeObject());
        }
        int[] selectedIndexes = this.mediator.getSelectedIndexes();
        return new LibraryPlaylistsTableTransferable(playlistItems, this.mediator.getCurrentPlaylist().getId(), selectedIndexes);
    }

    private boolean canImport(TransferHandler.TransferSupport support, boolean fallback) {
        if (!this.mediator.getMediaType().equals(MediaType.getAudioMediaType())) {
            return fallback && this.fallbackTransferHandler.canImport(support);
        }
        if (support.isDataFlavorSupported(LibraryPlaylistsTableTransferable.PLAYLIST_ITEM_ARRAY)) {
            Transferable transferable = support.getTransferable();
            try {
                LibraryPlaylistsTableTransferable.PlaylistItemContainer container = (LibraryPlaylistsTableTransferable.PlaylistItemContainer)transferable.getTransferData(LibraryPlaylistsTableTransferable.PLAYLIST_ITEM_ARRAY);
                if (this.mediator.getCurrentPlaylist().getId() == container.playlistID && ((LibraryPlaylistsTableModel)this.mediator.getDataModel()).getSortColumn() == 0 && ((LibraryPlaylistsTableModel)this.mediator.getDataModel()).isSortAscending()) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return DNDUtils.supportCanImport(LibraryPlaylistsTableTransferable.ITEM_ARRAY, support, this.fallbackTransferHandler, true);
    }

    private void importPlaylistItemArrayData(Transferable transferable, int index) throws UnsupportedFlavorException, IOException {
        PlaylistItem[] playlistItems = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferable.getTransferData(LibraryPlaylistsTableTransferable.PLAYLIST_ITEM_ARRAY));
        LibraryUtils.asyncAddToPlaylist(this.mediator.getCurrentPlaylist(), playlistItems, index);
    }
}

