/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.limewire.util.FileUtils;

public final class M3UPlaylist {
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String SONG_DELIM = "#EXTINF";
    private static final String SEC_DELIM = ":";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> load(String fileName) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File playListFile = new File(fileName);
        BufferedReader m3uFile = null;
        try {
            m3uFile = new BufferedReader(new FileReader(playListFile));
            String currLine = null;
            currLine = m3uFile.readLine();
            if (currLine == null) throw new IOException();
            if (!currLine.startsWith(M3U_HEADER) && !currLine.startsWith(SONG_DELIM)) {
                throw new IOException();
            }
            if (currLine.startsWith(M3U_HEADER)) {
                currLine = m3uFile.readLine();
            }
            while (currLine != null) {
                if (currLine.startsWith(SONG_DELIM)) {
                    currLine = m3uFile.readLine();
                    if (currLine == null) break;
                    File toAdd = new File(currLine);
                    if (toAdd.exists() && !toAdd.isDirectory()) {
                        files.add(toAdd);
                    } else {
                        toAdd = new File(playListFile.getParentFile().getAbsolutePath(), toAdd.getPath());
                        if (toAdd.exists() && !toAdd.isDirectory() && FileUtils.isReallyInParentPath(playListFile.getParentFile(), toAdd)) {
                            files.add(toAdd);
                        }
                    }
                }
                currLine = m3uFile.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(m3uFile);
            throw throwable;
        }
        IOUtils.closeQuietly(m3uFile);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String fileName, List<File> files) throws IOException {
        File playListFile = new File(fileName);
        if (files.size() == 0) {
            return;
        }
        PrintWriter m3uFile = null;
        try {
            m3uFile = new PrintWriter(new FileWriter(playListFile.getCanonicalPath(), false));
            m3uFile.write(M3U_HEADER);
            m3uFile.println();
            for (File currFile : files) {
                if (!currFile.isFile()) continue;
                File locFile = new File(currFile.toURI());
                m3uFile.write(SONG_DELIM);
                m3uFile.write(SEC_DELIM);
                m3uFile.write("-1,");
                m3uFile.write(currFile.getName());
                m3uFile.println();
                m3uFile.write(locFile.getCanonicalPath());
                m3uFile.println();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(m3uFile);
            throw throwable;
        }
        IOUtils.closeQuietly(m3uFile);
    }
}

