/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.RecursiveLibraryDirectoryPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RemoveLibraryDirectoryAction
extends AbstractAction {
    private static final long serialVersionUID = -6729288511779797455L;
    private final RecursiveLibraryDirectoryPanel recursiveSharingPanel;

    public RemoveLibraryDirectoryAction(RecursiveLibraryDirectoryPanel recursiveSharingPanel) {
        super(I18n.tr("Remove"));
        this.recursiveSharingPanel = recursiveSharingPanel;
        this.setEnabled(false);
        recursiveSharingPanel.getTree().addTreeSelectionListener(new EnablementSelectionListener());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File dir = (File)this.recursiveSharingPanel.getTree().getSelectionPath().getLastPathComponent();
        this.recursiveSharingPanel.removeRoot(dir);
    }

    private class EnablementSelectionListener
    implements TreeSelectionListener {
        private EnablementSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object obj = e.getPath().getLastPathComponent();
            if (obj instanceof File) {
                RemoveLibraryDirectoryAction.this.setEnabled(RemoveLibraryDirectoryAction.this.recursiveSharingPanel.isRoot((File)obj));
            } else {
                RemoveLibraryDirectoryAction.this.setEnabled(false);
            }
        }
    }
}

