/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.JaudiotaggerParser;
import com.frostwire.util.Logger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.flac.FlacFileReader;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.tag.flac.FlacTag;

class FlacParser
extends JaudiotaggerParser {
    private static final Logger LOG = Logger.getLogger(FlacParser.class);

    public FlacParser(File file) {
        super(file, new FlacFileReader());
    }

    @Override
    public BufferedImage getArtwork() {
        BufferedImage image = super.getArtwork();
        if (image == null) {
            try {
                List<MetadataBlockDataPicture> images;
                AudioFile audioFile = AudioFileIO.read(this.file);
                FlacTag tag = (FlacTag)audioFile.getTag();
                if (tag != null && (images = tag.getImages()) != null && !images.isEmpty()) {
                    MetadataBlockDataPicture picture = images.get(0);
                    byte[] data = picture.getImageData();
                    image = FlacParser.imageFromData(data);
                }
            }
            catch (Throwable e) {
                LOG.error("Unable to read cover art from flac");
            }
        }
        return image;
    }
}

