/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.JaudiotaggerParser;
import com.frostwire.util.Logger;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.audio.mp3.MP3FileReader;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.images.Artwork;

class MP3Parser
extends JaudiotaggerParser {
    private static final Logger LOG = Logger.getLogger(MP3Parser.class);

    public MP3Parser(File file) {
        super(file, new MP3FileReader());
    }

    @Override
    public BufferedImage getArtwork() {
        BufferedImage image = super.getArtwork();
        if (image == null) {
            try {
                AbstractID3v2Tag tag;
                Artwork artwork;
                MP3File mp3 = new MP3File(this.file.getAbsoluteFile());
                if (mp3.hasID3v2Tag() && (artwork = (tag = mp3.getID3v2Tag()).getFirstArtwork()) != null) {
                    byte[] data = artwork.getBinaryData();
                    image = MP3Parser.imageFromData(data);
                }
            }
            catch (Throwable e) {
                LOG.error("Unable to read cover art from mp3");
            }
        }
        return image;
    }

    @Override
    protected String getTitle(AudioFile audioFile) {
        return this.getValueSafe(super.getTitle(audioFile), audioFile, "TIT2");
    }

    @Override
    protected String getArtist(AudioFile audioFile) {
        return this.getValueSafe(super.getArtist(audioFile), audioFile, "TPE1");
    }

    @Override
    protected String getAlbum(AudioFile audioFile) {
        return this.getValueSafe(super.getAlbum(audioFile), audioFile, "TALB");
    }

    @Override
    protected String getComment(AudioFile audioFile) {
        return this.getValueSafe(super.getComment(audioFile), audioFile, "COMM");
    }

    @Override
    protected String getGenre(AudioFile audioFile) {
        return this.getValueSafe(super.getGenre(audioFile), audioFile, "TCON");
    }

    @Override
    protected String getTrack(AudioFile audioFile) {
        return this.getValueSafe(super.getTrack(audioFile), audioFile, "TRCK");
    }

    @Override
    protected String getYear(AudioFile audioFile) {
        return this.getValueSafe(super.getYear(audioFile), audioFile, "TDRC");
    }

    @Override
    protected String getLyrics(AudioFile audioFile) {
        return this.getValueSafe(this.getValueSafe(super.getLyrics(audioFile), audioFile, "SYLT"), audioFile, "USLT");
    }

    private String getValueSafe(String currentValue, AudioFile audioFile, String identifier) {
        String value = currentValue;
        if ((value == null || value.length() == 0) && audioFile instanceof MP3File && ((MP3File)audioFile).hasID3v2Tag()) {
            try {
                AbstractID3v2Tag v2tag = ((MP3File)audioFile).getID3v2Tag();
                value = v2tag.getFirst(identifier);
            }
            catch (Exception e) {
                LOG.warn("Unable to get value for ID3v2 tag key: " + identifier);
            }
        }
        return value;
    }
}

