/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.mplayer;

import com.frostwire.gui.mplayer.ProgressSliderListener;
import com.frostwire.gui.mplayer.TimeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressSlider
extends JPanel {
    private static final long serialVersionUID = 8000075870624583383L;
    private JSlider progressSlider;
    private JLabel remainingTime;
    private JLabel elapsedTime;
    private float totalTime = 0.0f;
    private float currentTime = 0.0f;
    private boolean mousePressed = false;
    private LinkedList<ProgressSliderListener> listeners = new LinkedList();

    public ProgressSlider() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setSize(new Dimension(411, 17));
        this.elapsedTime = new JLabel("--:--");
        Font font = new Font(this.elapsedTime.getFont().getFontName(), 1, 14);
        this.elapsedTime.setFont(font);
        this.elapsedTime.setForeground(Color.white);
        this.add((Component)this.elapsedTime, "West");
        this.progressSlider = new JSlider();
        this.progressSlider.setOpaque(false);
        this.progressSlider.setFocusable(false);
        this.progressSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ProgressSlider.this.mousePressed) {
                    float seconds = (float)((double)ProgressSlider.this.progressSlider.getValue() / 100.0 * (double)ProgressSlider.this.totalTime);
                    for (ProgressSliderListener l : ProgressSlider.this.listeners) {
                        l.onProgressSliderTimeValueChange(seconds);
                    }
                }
            }
        });
        this.progressSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ProgressSlider.this.mousePressed = true;
                for (ProgressSliderListener l : ProgressSlider.this.listeners) {
                    l.onProgressSliderMouseDown();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ProgressSlider.this.mousePressed = false;
                for (ProgressSliderListener l : ProgressSlider.this.listeners) {
                    l.onProgressSliderMouseUp();
                }
            }
        });
        this.add((Component)this.progressSlider, "Center");
        this.remainingTime = new JLabel("--:--");
        this.remainingTime.setFont(font);
        this.remainingTime.setForeground(Color.white);
        this.add((Component)this.remainingTime, "East");
    }

    public void addProgressSliderListener(ProgressSliderListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressSliderListener(ProgressSliderListener listener) {
        this.listeners.remove(listener);
    }

    public void setTotalTime(float seconds) {
        if (seconds != this.totalTime) {
            this.totalTime = seconds;
            this.currentTime = 0.0f;
            this.updateUIControls();
        }
    }

    public void setCurrentTime(float seconds) {
        if (seconds != this.currentTime) {
            this.currentTime = seconds;
            this.updateUIControls();
        }
    }

    private void updateUIControls() {
        this.elapsedTime.setText(TimeUtils.getTimeFormatedString((int)this.currentTime));
        this.remainingTime.setText(TimeUtils.getTimeFormatedString((int)(this.totalTime - this.currentTime)));
        int progressValue = (int)((double)(this.currentTime / this.totalTime) * 100.0);
        this.progressSlider.setValue(Math.max(0, Math.min(100, progressValue)));
    }
}

