/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.BuddyButton;
import com.frostwire.gui.searchfield.JXSearchFieldAddon;
import com.frostwire.gui.searchfield.JXTextField;
import com.frostwire.gui.searchfield.NativeSearchFieldSupport;
import com.frostwire.gui.searchfield.RecentSearches;
import com.frostwire.gui.searchfield.TextUIWrapper;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JXSearchField
extends JXTextField {
    private static final long serialVersionUID = -6555528038058656677L;
    private static final int DEFAULT_INSTANT_SEARCH_DELAY = 180;
    private static final KeyStroke CANCEL_KEY = KeyStroke.getKeyStroke(27, 0);
    private JButton findButton;
    private JButton cancelButton;
    private JButton popupButton;
    private LayoutStyle layoutStyle;
    private SearchMode searchMode = SearchMode.INSTANT;
    private boolean useSeperatePopupButton;
    private boolean useSeperatePopupButtonSet;
    private boolean layoutStyleSet;
    private int instantSearchDelay = 180;
    private boolean promptFontStyleSet;
    private Timer instantSearchTimer;
    private String recentSearchesSaveKey;
    private RecentSearches recentSearches;

    public JXSearchField() {
        this("");
    }

    public JXSearchField(String prompt) {
        super(prompt);
        this.setUseNativeSearchFieldIfPossible(true);
        this.setCancelAction(new ClearAction());
        this.setFindAction(new FindAction());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (CANCEL_KEY.equals(KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers()))) {
                    JXSearchField.this.getCancelAction().actionPerformed(new ActionEvent(JXSearchField.this, e.getID(), KeyEvent.getKeyText(e.getKeyCode())));
                }
            }
        });
        this.addPropertyChangeListener("JTextField.Search.FindPopup", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JPopupMenu oldPopup = (JPopupMenu)evt.getOldValue();
                JXSearchField.this.firePropertyChange("findPopupMenu", oldPopup, evt.getNewValue());
            }
        });
        this.addPropertyChangeListener("JTextField.Search.CancelAction", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActionListener oldAction = (ActionListener)evt.getOldValue();
                JXSearchField.this.firePropertyChange("cancelAction", oldAction, evt.getNewValue());
            }
        });
        this.addPropertyChangeListener("JTextField.Search.FindAction", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActionListener oldAction = (ActionListener)evt.getOldValue();
                JXSearchField.this.firePropertyChange("findAction", oldAction, evt.getNewValue());
            }
        });
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public boolean isInstantSearchMode() {
        return SearchMode.INSTANT.equals((Object)this.getSearchMode());
    }

    public boolean isRegularSearchMode() {
        return SearchMode.REGULAR.equals((Object)this.getSearchMode());
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
        this.firePropertyChange("searchMode", (Object)this.searchMode, (Object)this.searchMode);
    }

    public int getInstantSearchDelay() {
        return this.instantSearchDelay;
    }

    public void setInstantSearchDelay(int instantSearchDelay) {
        this.instantSearchDelay = instantSearchDelay;
        this.firePropertyChange("instantSearchDelay", this.instantSearchDelay, this.instantSearchDelay);
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    public boolean isVistaLayoutStyle() {
        return LayoutStyle.VISTA.equals((Object)this.getLayoutStyle());
    }

    public boolean isMacLayoutStyle() {
        return LayoutStyle.MAC.equals((Object)this.getLayoutStyle());
    }

    public void setLayoutStyle(LayoutStyle layoutStyle) {
        this.layoutStyleSet = true;
        this.layoutStyle = layoutStyle;
        this.firePropertyChange("layoutStyle", (Object)this.layoutStyle, (Object)this.layoutStyle);
    }

    @Override
    public void setMargin(Insets m) {
        super.setMargin(m);
    }

    public final ActionListener getCancelAction() {
        ActionListener a = NativeSearchFieldSupport.getCancelAction(this);
        if (a == null) {
            a = new ClearAction();
        }
        return a;
    }

    public final void setCancelAction(ActionListener cancelAction) {
        NativeSearchFieldSupport.setCancelAction(this, cancelAction);
    }

    public final JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = this.createCancelButton();
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JXSearchField.this.getCancelAction().actionPerformed(e);
                }
            });
        }
        return this.cancelButton;
    }

    protected JButton createCancelButton() {
        BuddyButton btn = new BuddyButton();
        return btn;
    }

    public final ActionListener getFindAction() {
        ActionListener a = NativeSearchFieldSupport.getFindAction(this);
        if (a == null) {
            a = new FindAction();
        }
        return a;
    }

    public final void setFindAction(ActionListener findAction) {
        NativeSearchFieldSupport.setFindAction(this, findAction);
    }

    public final JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = this.createFindButton();
            this.findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JXSearchField.this.getFindAction().actionPerformed(e);
                }
            });
        }
        return this.findButton;
    }

    protected JButton createFindButton() {
        BuddyButton btn = new BuddyButton();
        return btn;
    }

    public final JButton getPopupButton() {
        if (this.popupButton == null) {
            this.popupButton = this.createPopupButton();
        }
        return this.popupButton;
    }

    protected JButton createPopupButton() {
        return new BuddyButton();
    }

    public boolean isUseSeperatePopupButton() {
        return this.useSeperatePopupButton;
    }

    public void setUseSeperatePopupButton(boolean useSeperatePopupButton) {
        this.useSeperatePopupButtonSet = true;
        this.useSeperatePopupButton = useSeperatePopupButton;
        this.firePropertyChange("useSeperatePopupButton", this.useSeperatePopupButton, this.useSeperatePopupButton);
    }

    public boolean isUseNativeSearchFieldIfPossible() {
        return NativeSearchFieldSupport.isSearchField(this);
    }

    public void setUseNativeSearchFieldIfPossible(boolean useNativeSearchFieldIfPossible) {
        TextUIWrapper.getDefaultWrapper().uninstall(this);
        NativeSearchFieldSupport.setSearchField(this, useNativeSearchFieldIfPossible);
        TextUIWrapper.getDefaultWrapper().install(this, true);
        this.updateUI();
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        this.updateButtonState();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtonState();
    }

    protected void updateButtonState() {
        this.getCancelButton().setEnabled(this.isEditable() & this.isEnabled());
        this.getFindButton().setEnabled(this.isEnabled());
        this.getPopupButton().setEnabled(this.isEnabled());
    }

    public void setFindPopupMenu(JPopupMenu findPopupMenu) {
        if (this.isManagingRecentSearches()) {
            return;
        }
        NativeSearchFieldSupport.setFindPopupMenu(this, findPopupMenu);
    }

    public JPopupMenu getFindPopupMenu() {
        return NativeSearchFieldSupport.getFindPopupMenu(this);
    }

    public final boolean isManagingRecentSearches() {
        return this.recentSearches != null;
    }

    private boolean isValidRecentSearchesKey(String key) {
        return key != null && key.length() > 0;
    }

    public String getRecentSearchesSaveKey() {
        return this.recentSearchesSaveKey;
    }

    public void setRecentSearchesSaveKey(String recentSearchesSaveKey) {
        String oldName = this.getRecentSearchesSaveKey();
        this.recentSearchesSaveKey = recentSearchesSaveKey;
        if (this.recentSearches != null) {
            RecentSearches rs = this.recentSearches;
            this.recentSearches = null;
            rs.uninstall(this);
        }
        if (this.isValidRecentSearchesKey(recentSearchesSaveKey)) {
            this.recentSearches = new RecentSearches(recentSearchesSaveKey);
            this.recentSearches.install(this);
        }
        this.firePropertyChange("recentSearchesSaveKey", oldName, this.recentSearchesSaveKey);
    }

    public RecentSearches getRecentSearches() {
        return this.recentSearches;
    }

    public Timer getInstantSearchTimer() {
        if (this.instantSearchTimer == null) {
            this.instantSearchTimer = new Timer(0, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JXSearchField.this.postActionEvent();
                }
            });
            this.instantSearchTimer.setRepeats(false);
        }
        return this.instantSearchTimer;
    }

    @Override
    public boolean hasFocus() {
        if (this.getFindPopupMenu() != null && this.getFindPopupMenu().isVisible()) {
            return true;
        }
        return super.hasFocus();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getFindPopupMenu() != null) {
            SwingUtilities.updateComponentTreeUI(this.getFindPopupMenu());
        }
    }

    @Override
    public void setPromptFontStyle(Integer fontStyle) {
        super.setPromptFontStyle(fontStyle);
        this.promptFontStyleSet = true;
    }

    public void customSetUIProperty(String propertyName, Object value) {
        this.customSetUIProperty(propertyName, value, false);
    }

    public void customSetUIProperty(String propertyName, Object value, boolean override) {
        if (propertyName == "useSeperatePopupButton") {
            if (!this.useSeperatePopupButtonSet || override) {
                this.setUseSeperatePopupButton((Boolean)value);
                this.useSeperatePopupButtonSet = false;
            }
        } else if (propertyName == "layoutStyle") {
            if (!this.layoutStyleSet || override) {
                this.setLayoutStyle(LayoutStyle.valueOf(value.toString()));
                this.layoutStyleSet = false;
            }
        } else if (propertyName == "promptFontStyle") {
            if (!this.promptFontStyleSet || override) {
                this.setPromptFontStyle((Integer)value);
                this.promptFontStyleSet = false;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void postActionEvent() {
        this.getInstantSearchTimer().stop();
        super.postActionEvent();
    }

    static {
        new JXSearchFieldAddon().addDefaults();
    }

    public class FindAction
    extends AbstractAction {
        private static final long serialVersionUID = 6512288404613230232L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JXSearchField.this.isFocusOwner() && JXSearchField.this.isRegularSearchMode()) {
                JXSearchField.this.postActionEvent();
            }
            JXSearchField.this.requestFocusInWindow();
            JXSearchField.this.selectAll();
        }
    }

    class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = -3349455592229414653L;

        public ClearAction() {
            this.putValue("ShortDescription", "Clear Search Text");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.clear();
        }

        public void clear() {
            JXSearchField.this.setText(null);
            JXSearchField.this.requestFocusInWindow();
        }
    }

    public static enum SearchMode {
        REGULAR,
        INSTANT;

    }

    public static enum LayoutStyle {
        VISTA,
        MAC;

    }
}

