/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.ShellFolder;
import java.io.File;
import java.io.ObjectStreamException;

class DefaultShellFolder
extends ShellFolder {
    DefaultShellFolder(ShellFolder parent, File f) {
        super(parent, f.getAbsolutePath());
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return new File(this.getPath());
    }

    @Override
    public File[] listFiles() {
        File[] files = super.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i] = new DefaultShellFolder((ShellFolder)this, files[i]);
            }
        }
        return files;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isHidden() {
        String fileName = this.getName();
        if (fileName.length() > 0) {
            return fileName.charAt(0) == '.';
        }
        return false;
    }

    @Override
    public ShellFolder getLinkLocation() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getFolderType() {
        if (this.isDirectory()) {
            return "File Folder";
        }
        return "File";
    }

    @Override
    public String getExecutableType() {
        return null;
    }
}

