/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.DialogFinishedListener;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.limewire.util.OSUtils;

public final class FrostwireInputDialog
extends JDialog {
    private final String message;
    private final String textViewText;
    private final Icon icon;
    private final JTextField textView;
    private final DialogFinishedListener listener;
    private JButton buttonCancel;

    public static void showInputDialog(Frame parentComponent, String message, String title, Icon icon, String initialSelectionValue, DialogFinishedListener listener) {
        FrostwireInputDialog dialog = new FrostwireInputDialog(parentComponent, title, message, initialSelectionValue, icon, false, listener);
        dialog.setVisible(true);
    }

    private FrostwireInputDialog(Frame parentFrame, String windowTitle, String message, String textViewText, Icon icon, boolean modal, DialogFinishedListener listener) {
        super(parentFrame, windowTitle, modal);
        this.message = message;
        this.textViewText = textViewText;
        this.textView = new JTextField(textViewText != null ? textViewText : "");
        this.icon = icon;
        this.listener = listener;
        this.setDefaultCloseOperation(2);
        this.initContentPane();
    }

    private void initContentPane() {
        Dimension defaultDimension = new Dimension(500, 140);
        this.setMinimumSize(defaultDimension);
        this.setPreferredSize(defaultDimension);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        MigLayout layout = new MigLayout("insets 0, gap 5, fillx");
        contentPane.setLayout(layout);
        if (this.textViewText != null) {
            this.textView.selectAll();
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton buttonOk = new JButton(I18n.tr("Ok"));
        this.buttonCancel = new JButton(I18n.tr("Cancel"));
        if (OSUtils.isAnyMac()) {
            buttonPanel.add(this.buttonCancel);
            buttonPanel.add(buttonOk);
        } else {
            buttonPanel.add(buttonOk);
            buttonPanel.add(this.buttonCancel);
        }
        this.textView.addKeyListener(this.getKeyListener());
        this.initButtonListeners(buttonOk, false);
        this.initButtonListeners(this.buttonCancel, true);
        JLabel messageLabel = new JLabel(this.message);
        messageLabel.setBounds(10, 10, defaultDimension.width - 40, 24);
        if (this.icon != null) {
            messageLabel.setIcon(this.icon);
            messageLabel.setHorizontalAlignment(2);
        }
        contentPane.add((Component)messageLabel, "growx, gap 10 10 15 5, wrap");
        contentPane.add((Component)this.textView, "growx, gap 10 10 0 5, wrap, height 24!");
        contentPane.add((Component)buttonPanel, "gapright 5, align right");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - defaultDimension.width) / 2, (screenSize.height - defaultDimension.height) / 2, defaultDimension.width, defaultDimension.height);
    }

    private void initButtonListeners(JButton button, boolean cancelled) {
        button.addKeyListener(this.getKeyListener());
        button.addActionListener(this.getActionListener(cancelled));
    }

    private KeyListener getKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    FrostwireInputDialog.this.onButtonClicked(true);
                } else if (e.getKeyCode() == 10) {
                    FrostwireInputDialog.this.onButtonClicked(e.getComponent() == FrostwireInputDialog.this.buttonCancel);
                }
            }
        };
    }

    private ActionListener getActionListener(final boolean cancelled) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrostwireInputDialog.this.onButtonClicked(cancelled);
            }
        };
    }

    private void onButtonClicked(boolean cancelled) {
        String inputValue = cancelled ? null : this.textView.getText();
        this.dispose();
        if (cancelled) {
            this.listener.onDialogCancelled();
        } else {
            this.listener.onDialogOk(inputValue);
        }
    }
}

