/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.ShellFolderColumnInfo;
import com.frostwire.gui.theme.ShellFolderManager;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.List;
import java.util.Vector;

abstract class ShellFolder
extends File {
    protected ShellFolder parent;
    private static ShellFolderManager shellFolderManager;

    ShellFolder(ShellFolder parent, String pathname) {
        super(pathname != null ? pathname : "ShellFolder");
        this.parent = parent;
    }

    public boolean isFileSystem() {
        return !this.getPath().startsWith("ShellFolder");
    }

    protected abstract Object writeReplace() throws ObjectStreamException;

    @Override
    public String getParent() {
        if (this.parent == null && this.isFileSystem()) {
            return super.getParent();
        }
        if (this.parent != null) {
            return this.parent.getPath();
        }
        return null;
    }

    @Override
    public File getParentFile() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isFileSystem()) {
            return super.getParentFile();
        }
        return null;
    }

    @Override
    public File[] listFiles() {
        return this.listFiles(true);
    }

    public File[] listFiles(boolean includeHiddenFiles) {
        File[] files = super.listFiles();
        if (!includeHiddenFiles) {
            Vector<File> v = new Vector<File>();
            int nameCount = files == null ? 0 : files.length;
            for (int i = 0; i < nameCount; ++i) {
                if (files[i].isHidden()) continue;
                v.addElement(files[i]);
            }
            files = v.toArray(new File[v.size()]);
        }
        return files;
    }

    public abstract boolean isLink();

    public abstract ShellFolder getLinkLocation();

    public abstract String getDisplayName();

    public abstract String getFolderType();

    public abstract String getExecutableType();

    @Override
    public int compareTo(File file2) {
        if (file2 == null || !(file2 instanceof ShellFolder) || file2 instanceof ShellFolder && ((ShellFolder)file2).isFileSystem()) {
            if (this.isFileSystem()) {
                return super.compareTo(file2);
            }
            return -1;
        }
        if (this.isFileSystem()) {
            return 1;
        }
        return this.getName().compareTo(file2.getName());
    }

    public Image getIcon(boolean getLargeIcon) {
        return null;
    }

    public static ShellFolder getShellFolder(File file) throws FileNotFoundException {
        if (file instanceof ShellFolder) {
            return (ShellFolder)file;
        }
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        return shellFolderManager.createShellFolder(file);
    }

    public static Object get(String key) {
        return shellFolderManager.get(key);
    }

    public static boolean isComputerNode(File dir) {
        return shellFolderManager.isComputerNode(dir);
    }

    public static boolean isFileSystemRoot(File dir) {
        return shellFolderManager.isFileSystemRoot(dir);
    }

    public static File getNormalizedFile(File f) throws IOException {
        File canonical = f.getCanonicalFile();
        if (f.equals(canonical)) {
            return canonical;
        }
        return new File(f.toURI().normalize());
    }

    public static void sortFiles(List<Object> files) {
        shellFolderManager.sortFiles(files);
    }

    @Override
    public boolean isAbsolute() {
        return !this.isFileSystem() || super.isAbsolute();
    }

    @Override
    public File getAbsoluteFile() {
        return this.isFileSystem() ? super.getAbsoluteFile() : this;
    }

    @Override
    public boolean canRead() {
        return this.isFileSystem() ? super.canRead() : true;
    }

    @Override
    public boolean canWrite() {
        return this.isFileSystem() ? super.canWrite() : false;
    }

    @Override
    public boolean exists() {
        return !this.isFileSystem() || ShellFolder.isFileSystemRoot(this) || super.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.isFileSystem() ? super.isDirectory() : true;
    }

    @Override
    public boolean isFile() {
        return this.isFileSystem() ? super.isFile() : !this.isDirectory();
    }

    @Override
    public long lastModified() {
        return this.isFileSystem() ? super.lastModified() : 0L;
    }

    @Override
    public long length() {
        return this.isFileSystem() ? super.length() : 0L;
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this.isFileSystem() ? super.createNewFile() : false;
    }

    @Override
    public boolean delete() {
        return this.isFileSystem() ? super.delete() : false;
    }

    @Override
    public void deleteOnExit() {
        if (this.isFileSystem()) {
            super.deleteOnExit();
        }
    }

    @Override
    public boolean mkdir() {
        return this.isFileSystem() ? super.mkdir() : false;
    }

    @Override
    public boolean mkdirs() {
        return this.isFileSystem() ? super.mkdirs() : false;
    }

    @Override
    public boolean renameTo(File dest) {
        return this.isFileSystem() ? super.renameTo(dest) : false;
    }

    @Override
    public boolean setLastModified(long time) {
        return this.isFileSystem() ? super.setLastModified(time) : false;
    }

    @Override
    public boolean setReadOnly() {
        return this.isFileSystem() ? super.setReadOnly() : false;
    }

    @Override
    public String toString() {
        return this.isFileSystem() ? super.toString() : this.getDisplayName();
    }

    public static ShellFolderColumnInfo[] getFolderColumns(File dir) {
        return shellFolderManager.getFolderColumns(dir);
    }

    public static Object getFolderColumnValue(File file, int column) {
        return shellFolderManager.getFolderColumnValue(file, column);
    }

    public ShellFolderColumnInfo[] getFolderColumns() {
        return null;
    }

    public Object getFolderColumnValue(int column) {
        return null;
    }

    static {
        Class<ShellFolderManager> managerClass = ShellFolderManager.class;
        try {
            shellFolderManager = (ShellFolderManager)managerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new Error("Could not instantiate Shell Folder Manager: " + managerClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new Error("Could not access Shell Folder Manager: " + managerClass.getName());
        }
    }
}

