/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import com.frostwire.gui.theme.SkinColors;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.JComponent;

public final class SkinTabbedPaneTabBackgroundPainter
extends AbstractSkinPainter {
    private final State state;

    public SkinTabbedPaneTabBackgroundPainter(State state) {
        this.state = state;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case FocusedMouseOverSelected: 
            case FocusedPressedSelected: 
            case FocusedSelected: 
            case MouseOverSelected: 
            case PressedSelected: 
            case Selected: {
                this.paintSelectedTab(g, width, height);
                break;
            }
            default: {
                this.paintDefaultTab(g, width, height);
            }
        }
    }

    private void paintSelectedTab(Graphics2D g, int width, int height) {
        if (this.testValid(0, 0, width, height)) {
            Shape s = this.shapeGenerator.createRectangle(0, 0, width, height);
            g.setPaint(SkinColors.LIGHT_BACKGROUND_COLOR);
            g.fill(s);
            this.paintBorder(g, width, height);
        }
    }

    private void paintDefaultTab(Graphics2D g, int width, int height) {
        int w = width - 4;
        int h = height;
        if (this.testValid(0, 0, w, h)) {
            Shape s = this.shapeGenerator.createRectangle(0, 0, w, h);
            g.setPaint(SkinColors.GENERAL_BORDER_COLOR);
            g.fill(s);
            this.paintBorder(g, width, height);
        }
    }

    private void paintBorder(Graphics2D g, int width, int height) {
        Path2D.Double path = new Path2D.Double(0);
        path.reset();
        int w = width - 4;
        int h = height - 1;
        ((Path2D)path).moveTo(0.0, h);
        ((Path2D)path).lineTo(0.0, 0.0);
        ((Path2D)path).lineTo(w, 0.0);
        ((Path2D)path).lineTo(w, h);
        ((Path2D)path).lineTo(width, h);
        g.setPaint(SkinColors.GENERAL_BORDER_COLOR);
        g.draw(path);
    }

    public static enum State {
        DisabledSelected,
        Disabled,
        EnabledMouseOver,
        EnabledPressed,
        Enabled,
        FocusedMouseOverSelected,
        FocusedPressedSelected,
        FocusedSelected,
        MouseOverSelected,
        PressedSelected,
        Selected;

    }
}

