/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.AnnounceEntry;
import com.frostwire.jlibtorrent.MoveFlags;
import com.frostwire.jlibtorrent.PartialPieceInfo;
import com.frostwire.jlibtorrent.PeerInfo;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.add_piece_flags_t;
import com.frostwire.jlibtorrent.swig.announce_entry_vector;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.deadline_flags_t;
import com.frostwire.jlibtorrent.swig.int64_vector;
import com.frostwire.jlibtorrent.swig.int_vector;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.partial_piece_info_vector;
import com.frostwire.jlibtorrent.swig.peer_info_vector;
import com.frostwire.jlibtorrent.swig.reannounce_flags_t;
import com.frostwire.jlibtorrent.swig.resume_data_flags_t;
import com.frostwire.jlibtorrent.swig.status_flags_t;
import com.frostwire.jlibtorrent.swig.torrent_flags_t;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import com.frostwire.jlibtorrent.swig.torrent_info;
import com.frostwire.jlibtorrent.swig.torrent_status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TorrentHandle {
    private static final long REQUEST_STATUS_RESOLUTION_MILLIS = 500L;
    private static final status_flags_t STATUS_FLAGS_ZERO = new status_flags_t();
    private final torrent_handle th;
    private long lastStatusRequestTime;
    private TorrentStatus lastStatus;
    public static final add_piece_flags_t OVERWRITE_EXISTING = torrent_handle.overwrite_existing;
    public static final status_flags_t QUERY_DISTRIBUTED_COPIES = torrent_handle.query_distributed_copies;
    public static final status_flags_t QUERY_ACCURATE_DOWNLOAD_COUNTERS = torrent_handle.query_accurate_download_counters;
    public static final status_flags_t QUERY_LAST_SEEN_COMPLETE = torrent_handle.query_last_seen_complete;
    public static final status_flags_t QUERY_PIECES = torrent_handle.query_pieces;
    public static final status_flags_t QUERY_VERIFIED_PIECES = torrent_handle.query_verified_pieces;
    public static final status_flags_t QUERY_TORRENT_FILE = torrent_handle.query_torrent_file;
    public static final status_flags_t QUERY_NAME = torrent_handle.query_name;
    public static final status_flags_t QUERY_SAVE_PATH = torrent_handle.query_save_path;
    public static final resume_data_flags_t FLUSH_DISK_CACHE = torrent_handle.flush_disk_cache;
    public static final resume_data_flags_t SAVE_INFO_DICT = torrent_handle.save_info_dict;
    public static final resume_data_flags_t ONLY_IF_MODIFIED = torrent_handle.only_if_modified;
    public static final reannounce_flags_t IGNORE_MIN_INTERVAL = torrent_handle.ignore_min_interval;
    public static final deadline_flags_t ALERT_WHEN_AVAILABLE = torrent_handle.alert_when_available;

    public TorrentHandle(torrent_handle th) {
        this.th = th;
    }

    public torrent_handle swig() {
        return this.th;
    }

    public void addPiece(int piece, byte[] data, add_piece_flags_t flags) {
        this.th.add_piece_bytes(piece, Vectors.bytes2byte_vector(data), flags);
    }

    public void addPiece(int piece, byte[] data) {
        this.th.add_piece_bytes(piece, Vectors.bytes2byte_vector(data));
    }

    public void readPiece(int piece) {
        this.th.read_piece(piece);
    }

    public boolean havePiece(int piece) {
        return this.th.have_piece(piece);
    }

    public List<PeerInfo> peerInfo() {
        if (!this.th.is_valid()) {
            return new ArrayList<PeerInfo>();
        }
        peer_info_vector v = new peer_info_vector();
        this.th.get_peer_info(v);
        int size = (int)v.size();
        ArrayList<PeerInfo> l = new ArrayList<PeerInfo>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new PeerInfo(v.get(i)));
        }
        return l;
    }

    public TorrentInfo torrentFile() {
        if (!this.th.is_valid()) {
            return null;
        }
        torrent_info ti = this.th.torrent_file_ptr();
        return ti != null ? new TorrentInfo(ti) : null;
    }

    public TorrentStatus status(boolean force) {
        long now = System.currentTimeMillis();
        if (force || now - this.lastStatusRequestTime >= 500L) {
            this.lastStatusRequestTime = now;
            this.lastStatus = new TorrentStatus(this.th.status(STATUS_FLAGS_ZERO));
        }
        return this.lastStatus;
    }

    public TorrentStatus status() {
        return this.status(false);
    }

    public TorrentStatus status(status_flags_t flags) {
        return new TorrentStatus(this.th.status(flags));
    }

    public ArrayList<PartialPieceInfo> getDownloadQueue() {
        partial_piece_info_vector v = new partial_piece_info_vector();
        this.th.get_download_queue(v);
        int size = (int)v.size();
        ArrayList<PartialPieceInfo> l = new ArrayList<PartialPieceInfo>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new PartialPieceInfo(v.get(i)));
        }
        return l;
    }

    public Sha1Hash infoHash() {
        return new Sha1Hash(this.th.info_hash());
    }

    public void pause() {
        this.th.pause();
    }

    public void resume() {
        this.th.resume();
    }

    public torrent_flags_t flags() {
        return this.th.flags();
    }

    public void setFlags(torrent_flags_t flags, torrent_flags_t mask) {
        this.th.set_flags(flags, mask);
    }

    public void setFlags(torrent_flags_t flags) {
        this.th.set_flags(flags);
    }

    public void unsetFlags(torrent_flags_t flags) {
        this.th.unset_flags(flags);
    }

    public void flushCache() {
        this.th.flush_cache();
    }

    public boolean needSaveResumeData() {
        return this.th.need_save_resume_data();
    }

    public int queuePosition() {
        return this.th.queue_position2();
    }

    public void queuePositionUp() {
        this.th.queue_position_up();
    }

    public void queuePositionDown() {
        this.th.queue_position_down();
    }

    public void queuePositionTop() {
        this.th.queue_position_top();
    }

    public void queuePositionBottom() {
        this.th.queue_position_bottom();
    }

    public void queuePositionSet(int position) {
        this.th.queue_position_set2(position);
    }

    public void setSslCertificate(String certificate, String privateKey, String dhParams) {
        this.th.set_ssl_certificate(certificate, privateKey, dhParams);
    }

    public void setSslCertificate(String certificate, String privateKey, String dhParams, String passphrase) {
        this.th.set_ssl_certificate(certificate, privateKey, dhParams, passphrase);
    }

    void setSslCertificateBuffer(byte[] certificate, byte[] privateKey, byte[] dhParams) {
        byte_vector cert = Vectors.bytes2byte_vector(certificate);
        byte_vector pk = Vectors.bytes2byte_vector(privateKey);
        byte_vector dh = Vectors.bytes2byte_vector(dhParams);
        this.th.set_ssl_certificate_buffer2(cert, pk, dh);
    }

    public void saveResumeData(resume_data_flags_t flags) {
        this.th.save_resume_data(flags);
    }

    public void saveResumeData() {
        this.th.save_resume_data();
    }

    public boolean isValid() {
        return this.th.is_valid();
    }

    public String makeMagnetUri() {
        return this.th.is_valid() ? libtorrent.make_magnet_uri(this.th) : null;
    }

    public int getUploadLimit() {
        return this.th.upload_limit();
    }

    public void setUploadLimit(int limit) {
        this.th.set_upload_limit(limit);
    }

    public int getDownloadLimit() {
        return this.th.download_limit();
    }

    public void setDownloadLimit(int limit) {
        this.th.set_download_limit(limit);
    }

    public void forceRecheck() {
        this.th.force_recheck();
    }

    public void forceReannounce(int seconds, int tracker_index, reannounce_flags_t flags) {
        this.th.force_reannounce(seconds, tracker_index, flags);
    }

    public void forceReannounce(int seconds, int tracker_index) {
        this.th.force_reannounce(seconds, tracker_index);
    }

    public void forceReannounce(int seconds) {
        this.th.force_reannounce(seconds);
    }

    public void forceReannounce() {
        this.th.force_reannounce();
    }

    public void forceDHTAnnounce() {
        this.th.force_dht_announce();
    }

    public List<AnnounceEntry> trackers() {
        if (!this.th.is_valid()) {
            return Collections.emptyList();
        }
        return TorrentInfo.trackers(this.th.trackers());
    }

    public void scrapeTracker() {
        this.th.scrape_tracker();
    }

    public void replaceTrackers(List<AnnounceEntry> trackers) {
        announce_entry_vector v = new announce_entry_vector();
        for (AnnounceEntry t : trackers) {
            v.push_back(t.swig());
        }
        this.th.replace_trackers(v);
    }

    public void addTracker(AnnounceEntry tracker) {
        this.th.add_tracker(tracker.swig());
    }

    public void addUrlSeed(String url) {
        this.th.add_url_seed(url);
    }

    public void removeUrlSeed(String url) {
        this.th.remove_url_seed(url);
    }

    public List<String> urlSeeds() {
        return Vectors.string_vector2list(this.th.get_url_seeds());
    }

    public void addHttpSeed(String url) {
        this.th.add_url_seed(url);
    }

    public void removeHttpSeed(String url) {
        this.th.remove_http_seed(url);
    }

    public List<String> httpSeeds() {
        return Vectors.string_vector2list(this.th.get_http_seeds());
    }

    public int[] pieceAvailability() {
        int_vector v = new int_vector();
        this.th.piece_availability(v);
        return Vectors.int_vector2ints(v);
    }

    public void piecePriority(int index, Priority priority) {
        this.th.piece_priority2(index, priority.swig());
    }

    public Priority piecePriority(int index) {
        return Priority.fromSwig(this.th.piece_priority2(index));
    }

    public void prioritizePieces(Priority[] priorities) {
        this.th.prioritize_pieces2(Priority.array2vector(priorities));
    }

    public Priority[] piecePriorities() {
        int_vector v = this.th.get_piece_priorities2();
        int size = (int)v.size();
        Priority[] arr = new Priority[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = Priority.fromSwig(v.get(i));
        }
        return arr;
    }

    public void filePriority(int index, Priority priority) {
        this.th.file_priority2(index, priority.swig());
    }

    public Priority filePriority(int index) {
        return Priority.fromSwig(this.th.file_priority2(index));
    }

    public void prioritizeFiles(Priority[] priorities) {
        this.th.prioritize_files2(Priority.array2vector(priorities));
    }

    public Priority[] filePriorities() {
        int_vector v = this.th.get_file_priorities2();
        int size = (int)v.size();
        Priority[] arr = new Priority[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = Priority.fromSwig(v.get(i));
        }
        return arr;
    }

    public void setPieceDeadline(int index, int deadline) {
        this.th.set_piece_deadline(index, deadline);
    }

    public void setPieceDeadline(int index, int deadline, deadline_flags_t flags) {
        this.th.set_piece_deadline(index, deadline, flags);
    }

    public void resetPieceDeadline(int index) {
        this.th.reset_piece_deadline(index);
    }

    public void clearPieceDeadlines() {
        this.th.clear_piece_deadlines();
    }

    public long[] fileProgress(FileProgressFlags flags) {
        int64_vector v = new int64_vector();
        this.th.file_progress(v, flags.swig());
        return Vectors.int64_vector2longs(v);
    }

    public long[] fileProgress() {
        int64_vector v = new int64_vector();
        this.th.file_progress(v);
        return Vectors.int64_vector2longs(v);
    }

    public String savePath() {
        torrent_status ts = this.th.status(torrent_handle.query_save_path);
        return ts.getSave_path();
    }

    public String name() {
        torrent_status ts = this.th.status(torrent_handle.query_name);
        return ts.getName();
    }

    public void moveStorage(String savePath, MoveFlags flags) {
        this.th.move_storage(savePath, flags.swig());
    }

    public void moveStorage(String savePath) {
        this.th.move_storage(savePath);
    }

    public void renameFile(int index, String newName) {
        this.th.rename_file(index, newName);
    }

    public static enum FileProgressFlags {
        PIECE_GRANULARITY(torrent_handle.file_progress_flags_t.piece_granularity.swigValue());

        private final int swigValue;

        private FileProgressFlags(int swigValue) {
            this.swigValue = swigValue;
        }

        public int swig() {
            return this.swigValue;
        }
    }
}

