/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2FrameData;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.InvalidDataException;

public class ID3v2CommentFrameData
extends AbstractID3v2FrameData {
    private static final String DEFAULT_LANGUAGE = "eng";
    private String language;
    private EncodedText description;
    private EncodedText comment;

    public ID3v2CommentFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2CommentFrameData(boolean unsynchronisation, String language, EncodedText description, EncodedText comment) {
        super(unsynchronisation);
        this.language = language;
        this.description = description;
        this.comment = comment;
    }

    public ID3v2CommentFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        int marker;
        this.language = BufferTools.byteBufferToString(bytes, 1, 3);
        for (marker = 4; marker < bytes.length && bytes[marker] != 0; ++marker) {
        }
        this.description = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, 4, marker - 4));
        int length = 0;
        for (int i = marker + 1; i < bytes.length && bytes[i] != 0; ++i) {
            ++length;
        }
        this.comment = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, marker + 1, length));
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        bytes[0] = this.comment != null ? this.comment.getTextEncoding() : (byte)0;
        String langPadded = this.language == null ? DEFAULT_LANGUAGE : (this.language.length() > 3 ? this.language.substring(0, 3) : BufferTools.padStringRight(this.language, 3, ' '));
        BufferTools.stringIntoByteBuffer(langPadded, 0, 3, bytes, 1);
        int descriptionLength = 0;
        if (this.description != null && this.description.toBytes().length > 0) {
            descriptionLength = this.description.toBytes().length;
            BufferTools.copyIntoByteBuffer(this.description.toBytes(), 0, descriptionLength, bytes, 4);
        }
        bytes[descriptionLength + 4] = 0;
        if (this.comment != null && this.comment.toBytes().length > 0) {
            BufferTools.copyIntoByteBuffer(this.comment.toBytes(), 0, this.comment.toBytes().length, bytes, descriptionLength + 5);
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 5;
        if (this.description != null) {
            length += this.description.toBytes().length;
        }
        if (this.comment != null) {
            length += this.comment.toBytes().length;
        }
        return length;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public EncodedText getComment() {
        return this.comment;
    }

    public void setComment(EncodedText comment) {
        this.comment = comment;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText description) {
        this.description = description;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2CommentFrameData)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ID3v2CommentFrameData other = (ID3v2CommentFrameData)obj;
        if (this.language == null) {
            if (other.language != null) {
                return false;
            }
        } else {
            if (other.language == null) {
                return false;
            }
            if (!this.language.equals(other.language)) {
                return false;
            }
        }
        if (this.description == null) {
            if (other.description != null) {
                return false;
            }
        } else {
            if (other.description == null) {
                return false;
            }
            if (!this.description.equals(other.description)) {
                return false;
            }
        }
        if (this.comment == null) {
            if (other.comment != null) {
                return false;
            }
        } else {
            if (other.comment == null) {
                return false;
            }
            if (!this.comment.equals(other.comment)) {
                return false;
            }
        }
        return true;
    }
}

