/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.ID3v2Frame;
import com.frostwire.mp3.InvalidDataException;
import com.frostwire.mp3.NotSupportedException;

public class ID3v2ObseleteFrame
extends ID3v2Frame {
    private static final int HEADER_LENGTH = 6;
    private static final int ID_OFFSET = 0;
    private static final int ID_LENGTH = 3;
    protected static final int DATA_LENGTH_OFFSET = 3;

    public ID3v2ObseleteFrame(byte[] buffer, int offset) throws InvalidDataException {
        super(buffer, offset);
    }

    public ID3v2ObseleteFrame(String id, byte[] data) {
        super(id, data);
    }

    @Override
    protected int unpackHeader(byte[] buffer, int offset) {
        this.id = BufferTools.byteBufferToString(buffer, offset + 0, 3);
        this.unpackDataLength(buffer, offset);
        return offset + 6;
    }

    @Override
    protected void unpackDataLength(byte[] buffer, int offset) {
        this.dataLength = BufferTools.unpackInteger((byte)0, buffer[offset + 3], buffer[offset + 3 + 1], buffer[offset + 3 + 2]);
    }

    @Override
    public void packFrame(byte[] bytes, int offset) throws NotSupportedException {
        throw new NotSupportedException("Packing Obselete frames is not supported");
    }

    @Override
    public int getLength() {
        return this.dataLength + 6;
    }
}

