/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2FrameData;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.InvalidDataException;
import java.util.Arrays;

public class ID3v2PictureFrameData
extends AbstractID3v2FrameData {
    protected String mimeType;
    protected byte pictureType;
    protected EncodedText description;
    protected byte[] imageData;

    public ID3v2PictureFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2PictureFrameData(boolean unsynchronisation, String mimeType, byte pictureType, EncodedText description, byte[] imageData) {
        super(unsynchronisation);
        this.mimeType = mimeType;
        this.pictureType = pictureType;
        this.description = description;
        this.imageData = imageData;
    }

    public ID3v2PictureFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        int marker2;
        int marker;
        for (marker = 1; marker < bytes.length && bytes[marker] != 0; ++marker) {
        }
        this.mimeType = BufferTools.byteBufferToString(bytes, 1, marker - 1);
        this.pictureType = bytes[marker + 1];
        for (marker2 = marker += 2; marker2 < bytes.length && bytes[marker2] != 0; ++marker2) {
        }
        this.description = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, marker, marker2 - marker));
        this.imageData = BufferTools.copyBuffer(bytes, marker2 + 1, bytes.length - marker2 - 1);
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        bytes[0] = this.description != null ? this.description.getTextEncoding() : (byte)0;
        int mimeTypeLength = 0;
        if (this.mimeType != null && this.mimeType.length() > 0) {
            mimeTypeLength = this.mimeType.length();
            BufferTools.stringIntoByteBuffer(this.mimeType, 0, mimeTypeLength, bytes, 1);
        }
        bytes[mimeTypeLength + 1] = 0;
        bytes[mimeTypeLength + 2] = this.pictureType;
        int descriptionLength = 0;
        if (this.description != null && this.description.toBytes().length > 0) {
            descriptionLength = this.description.toBytes().length;
            BufferTools.copyIntoByteBuffer(this.description.toBytes(), 0, descriptionLength, bytes, mimeTypeLength + 3);
        }
        bytes[mimeTypeLength + descriptionLength + 3] = 0;
        if (this.imageData != null && this.imageData.length > 0) {
            BufferTools.copyIntoByteBuffer(this.imageData, 0, this.imageData.length, bytes, mimeTypeLength + descriptionLength + 4);
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 4;
        if (this.mimeType != null) {
            length += this.mimeType.length();
        }
        if (this.description != null) {
            length += this.description.toBytes().length;
        }
        if (this.imageData != null) {
            length += this.imageData.length;
        }
        return length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public byte getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(byte pictureType) {
        this.pictureType = pictureType;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText description) {
        this.description = description;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2PictureFrameData)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ID3v2PictureFrameData other = (ID3v2PictureFrameData)obj;
        if (this.pictureType != other.pictureType) {
            return false;
        }
        if (this.mimeType == null) {
            if (other.mimeType != null) {
                return false;
            }
        } else {
            if (other.mimeType == null) {
                return false;
            }
            if (!this.mimeType.equals(other.mimeType)) {
                return false;
            }
        }
        if (this.description == null) {
            if (other.description != null) {
                return false;
            }
        } else {
            if (other.description == null) {
                return false;
            }
            if (!this.description.equals(other.description)) {
                return false;
            }
        }
        if (this.imageData == null) {
            if (other.imageData != null) {
                return false;
            }
        } else {
            if (other.imageData == null) {
                return false;
            }
            if (!Arrays.equals(this.imageData, other.imageData)) {
                return false;
            }
        }
        return true;
    }
}

