/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AppleDataBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class AppleCoverBox
extends AppleDataBox {
    private static final int IMAGE_TYPE_JPG = 13;
    private static final int IMAGE_TYPE_PNG = 14;
    private byte[] value;

    AppleCoverBox() {
        super(covr);
    }

    public byte[] value() {
        return this.value;
    }

    public void setJpg(byte[] data) {
        this.value(data, 13);
    }

    public void setPng(byte[] data) {
        this.value(data, 14);
    }

    private void value(byte[] value, int dataType) {
        this.value = value;
        if (value != null) {
            this.dataLength = value.length + 16;
            this.dataType = dataType;
        }
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        int len = (int)(this.length() - 16L);
        if (len != 0) {
            this.value = new byte[len];
            buf = ByteBuffer.wrap(this.value);
            IO.read(ch, len, buf);
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.value != null) {
            buf = ByteBuffer.wrap(this.value);
            IO.write(ch, this.value.length, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 16L;
        if (this.value != null) {
            s += (long)this.value.length;
        }
        this.length(s);
    }
}

