/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import com.frostwire.mp4.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class HandlerBox
extends FullBox {
    protected int pre_defined;
    protected int handler_type;
    protected final int[] reserved = new int[3];
    protected byte[] name = new byte[0];

    HandlerBox() {
        super(hdlr);
    }

    public String name() {
        return Utf8.convert(this.name);
    }

    public void name(String value) {
        this.name = value != null ? Utf8.convert(value) : new byte[]{};
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        int len = (int)(this.length() - 4L);
        IO.read(ch, len, buf);
        this.pre_defined = buf.getInt();
        this.handler_type = buf.getInt();
        IO.get(buf, this.reserved);
        if (buf.remaining() > 0) {
            this.name = IO.str(buf);
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.pre_defined);
        buf.putInt(this.handler_type);
        IO.put(buf, this.reserved);
        buf.put(this.name);
        buf.put((byte)0);
        IO.write(ch, buf.position(), buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 20L;
        this.length(s += (long)(this.name.length + 1));
    }
}

