/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Bits;
import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class MediaHeaderBox
extends FullBox {
    protected long creation_time;
    protected long modification_time;
    protected int timescale;
    protected long duration;
    private byte[] language = new byte[2];
    protected short pre_defined;

    MediaHeaderBox() {
        super(mdhd);
    }

    public String language() {
        return Bits.iso639(this.language);
    }

    public void language(String value) {
        this.language = value != null ? Bits.iso639(value) : new byte[2];
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, (this.version == 1 ? 28 : 16) + 4, buf);
        if (this.version == 1) {
            this.creation_time = buf.getLong();
            this.modification_time = buf.getLong();
            this.timescale = buf.getInt();
            this.duration = buf.getLong();
        } else {
            this.creation_time = buf.getInt();
            this.modification_time = buf.getInt();
            this.timescale = buf.getInt();
            this.duration = buf.getInt();
        }
        buf.get(this.language);
        this.pre_defined = buf.getShort();
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.version == 1) {
            buf.putLong(this.creation_time);
            buf.putLong(this.modification_time);
            buf.putInt(this.timescale);
            buf.putLong(this.duration);
        } else {
            buf.putInt((int)this.creation_time);
            buf.putInt((int)this.modification_time);
            buf.putInt(this.timescale);
            buf.putInt((int)this.duration);
        }
        buf.put(this.language);
        buf.putShort(this.pre_defined);
        IO.write(ch, (this.version == 1 ? 28 : 16) + 4, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s = this.version == 1 ? (s += 28L) : (s += 16L);
        s += 2L;
        this.length(s += 2L);
    }
}

