/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.regex;

import com.frostwire.regex.Pattern;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Matcher {
    private com.google.re2j.Matcher matcher;
    private Pattern parentPattern;

    Matcher(Pattern parentPattern, CharSequence input) {
        this.parentPattern = parentPattern;
        this.matcher = parentPattern.pattern().matcher(input);
    }

    public com.google.re2j.Pattern standardPattern() {
        return this.matcher.pattern();
    }

    public Pattern namedPattern() {
        return this.parentPattern;
    }

    public Matcher reset() {
        this.matcher.reset();
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.matcher.reset(input);
        return this;
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean find() {
        return this.matcher.find();
    }

    public boolean find(int start) {
        return this.matcher.find(start);
    }

    public boolean lookingAt() {
        return this.matcher.lookingAt();
    }

    public StringBuffer appendTail(StringBuffer sb) {
        return this.matcher.appendTail(sb);
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int group) {
        return this.matcher.group(group);
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public List<String> orderedGroups() {
        int groupCount = this.groupCount();
        ArrayList<String> groups = new ArrayList<String>(groupCount);
        for (int i = 1; i <= groupCount; ++i) {
            groups.add(this.group(i));
        }
        return groups;
    }

    public String group(String groupName) {
        int idx = this.groupIndex(groupName);
        if (idx < 0) {
            throw new IndexOutOfBoundsException("No group \"" + groupName + "\"");
        }
        return this.group(idx);
    }

    public Map<String, String> namedGroups() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.matcher.find(0)) {
            for (String groupName : this.parentPattern.groupNames()) {
                String groupValue = this.matcher.group(this.groupIndex(groupName));
                result.put(groupName, groupValue);
            }
        }
        return result;
    }

    private int groupIndex(String groupName) {
        int idx = this.parentPattern.indexOf(groupName);
        return idx > -1 ? idx + 1 : -1;
    }

    public boolean hasGroup(String groupName) {
        return this.groupIndex(groupName) != -1;
    }

    public int start() {
        return this.matcher.start();
    }

    public int start(int group) {
        return this.matcher.start(group);
    }

    public int start(String groupName) {
        return this.start(this.groupIndex(groupName));
    }

    public int end() {
        return this.matcher.end();
    }

    public int end(int group) {
        return this.matcher.end(group);
    }

    public int end(String groupName) {
        return this.end(this.groupIndex(groupName));
    }

    public String replaceAll(String replacement) {
        return this.matcher.replaceAll(replacement);
    }

    public String replaceFirst(String replacement) {
        return this.matcher.replaceFirst(replacement);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matcher)) {
            return false;
        }
        Matcher other = (Matcher)obj;
        if (!this.parentPattern.equals(other.parentPattern)) {
            return false;
        }
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.parentPattern.hashCode() ^ this.matcher.hashCode();
    }

    public String toString() {
        return this.matcher.toString();
    }
}

