/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.util.Logger;
import java.util.List;

public abstract class AbstractSearchPerformer
implements SearchPerformer {
    private static final Logger LOG = Logger.getLogger(AbstractSearchPerformer.class);
    private final long token;
    private SearchListener listener;
    private boolean stopped;

    public AbstractSearchPerformer(long token) {
        this.token = token;
        this.stopped = false;
    }

    @Override
    public long getToken() {
        return this.token;
    }

    @Override
    public void stop() {
        this.stopped = true;
        try {
            if (this.listener != null) {
                this.listener.onStopped(this.token);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error sending finished signal to listener: " + e.getMessage());
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public SearchListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(SearchListener listener) {
        this.listener = listener;
    }

    protected void onResults(List<? extends SearchResult> results) {
        try {
            if (results != null && !this.stopped) {
                this.listener.onResults(this.token, results);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error sending results to listener: " + e.getMessage());
        }
    }
}

