/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.content.ContentValues;
import com.frostwire.content.Context;
import com.frostwire.database.Cursor;
import com.frostwire.database.sqlite.SQLiteDatabase;
import com.frostwire.database.sqlite.SQLiteOpenHelper;
import com.frostwire.database.sqlite.SQLiteQueryBuilder;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class CrawlCacheDB {
    private static final Logger LOG = Logger.getLogger(CrawlCacheDB.class);
    private static final String DATABASE_NAME = "crawldb";
    private static final int DATABASE_VERSION = 1;
    private static final String TABLE_NAME = "CacheData";
    private static final String DEFAULT_SORT_ORDER = "dateAdded DESC";
    private static final CrawlCacheDB instance;
    private DatabaseHelper databaseHelper = new DatabaseHelper(new Context());

    public static CrawlCacheDB instance() {
        return instance;
    }

    private CrawlCacheDB() {
    }

    public Cursor query(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables(TABLE_NAME);
        String orderBy = StringUtils.isEmpty(sortOrder) ? DEFAULT_SORT_ORDER : sortOrder;
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        return qb.query(db, projection, selection, selectionArgs, null, null, orderBy);
    }

    public long insert(ContentValues initialValues) {
        ContentValues values = initialValues != null ? new ContentValues(initialValues) : new ContentValues();
        Long now = System.currentTimeMillis() / 1000L;
        if (!values.containsKey("dateAdded")) {
            values.put("dateAdded", now);
        }
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        return db.insert(TABLE_NAME, "", values);
    }

    public int delete(String where, String[] whereArgs) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        return db.delete(TABLE_NAME, where, whereArgs);
    }

    void truncate() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        db.execSQL("TRUNCATE TABLE CacheData");
    }

    public int update(ContentValues values, String where, String[] whereArgs) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        return db.update(TABLE_NAME, values, where, whereArgs);
    }

    long sizeInBytes() {
        return this.databaseHelper.sizeInBytes();
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        instance = new CrawlCacheDB();
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, CrawlCacheDB.DATABASE_NAME, null, 1, "CACHE_SIZE=4096;CACHE_TYPE=SOFT_TQ");
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            if (SearchSettings.SMART_SEARCH_DATABASE_FOLDER.getValue().exists()) {
                try {
                    FileUtils.deleteDirectory(SearchSettings.SMART_SEARCH_DATABASE_FOLDER.getValue());
                }
                catch (IOException e) {
                    LOG.warn("Unable to delete old smart search database");
                }
            }
            db.execSQL("SET IGNORECASE TRUE");
            db.execSQL("CREATE TABLE CacheData (id INTEGER IDENTITY,key VARCHAR,data BINARY,dateAdded BIGINT);");
            db.execSQL("CREATE INDEX idx_CacheData_id ON CacheData (id)");
            db.execSQL("CREATE INDEX idx_CacheData_key ON CacheData (key)");
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            LOG.warn("Upgrading documents database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data");
            db.execSQL("DROP TABLE IF EXISTS CacheData");
            this.onCreate(db);
        }
    }

    public static final class Columns {
        public static final String ID = "id";
        static final String KEY = "key";
        public static final String DATA = "data";
        static final String DATE_ADDED = "dateAdded";

        private Columns() {
        }
    }
}

