/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.search.CrawlPagedWebSearchPerformer;
import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.PerformersHelper;
import com.frostwire.search.RegexSearchPerformer;
import com.frostwire.search.SearchResult;
import java.util.Collections;
import java.util.List;

public abstract class CrawlRegexSearchPerformer<T extends CrawlableSearchResult>
extends CrawlPagedWebSearchPerformer<T>
implements RegexSearchPerformer<T> {
    private final int regexMaxResults;

    public CrawlRegexSearchPerformer(String domainName, long token, String keywords, int timeout, int pages, int numCrawls, int regexMaxResults) {
        super(domainName, token, keywords, timeout, pages, numCrawls);
        this.regexMaxResults = regexMaxResults;
    }

    @Override
    protected List<? extends SearchResult> searchPage(String page) {
        if (!this.isValidHtml(page)) {
            return Collections.emptyList();
        }
        int prefixOffset = this.preliminaryHtmlPrefixOffset(page);
        int suffixOffset = this.preliminaryHtmlSuffixOffset(page);
        String reducedPage = PerformersHelper.reduceHtml(page, prefixOffset, suffixOffset);
        return PerformersHelper.searchPageHelper(this, reducedPage, this.regexMaxResults);
    }

    protected abstract boolean isValidHtml(String var1);

    protected int preliminaryHtmlSuffixOffset(String page) {
        return page.length();
    }

    protected int preliminaryHtmlPrefixOffset(String page) {
        return 0;
    }
}

