/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.search.SearchResult;
import com.frostwire.search.WebSearchPerformer;
import com.frostwire.util.Logger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public abstract class PagedWebSearchPerformer
extends WebSearchPerformer {
    private static final Logger LOG = Logger.getLogger(PagedWebSearchPerformer.class);
    private final int pages;

    public PagedWebSearchPerformer(String domainName, long token, String keywords, int timeout, int pages) {
        super(domainName, token, keywords, timeout);
        this.pages = pages;
    }

    @Override
    public void perform() {
        for (int i = 1; !this.isStopped() && i <= this.pages; ++i) {
            this.onResults(this.searchPage(i));
        }
    }

    protected List<? extends SearchResult> searchPage(int page) {
        List<Object> result = Collections.emptyList();
        String url = null;
        try {
            url = this.getUrl(page, this.getEncodedKeywords());
            String text = this.fetchSearchPage(url);
            if (text != null) {
                result = this.searchPage(text);
            }
        }
        catch (Throwable e) {
            if (url == null) {
                url = "n.a";
            }
            LOG.error("Error searching page [" + url + "]: " + e.getMessage());
        }
        return result;
    }

    protected String fetchSearchPage(String url) throws IOException {
        return this.fetch(url);
    }

    protected abstract String getUrl(int var1, String var2);

    protected abstract List<? extends SearchResult> searchPage(String var1);
}

