/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.archiveorg;

import com.frostwire.licenses.License;
import com.frostwire.licenses.Licenses;
import com.frostwire.search.AbstractSearchResult;
import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.archiveorg.ArchiveorgItem;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

public final class ArchiveorgSearchResult
extends AbstractSearchResult
implements CrawlableSearchResult {
    private final String identifier;
    private final String title;
    private final String detailsUrl;
    private final String domainName;
    private final License licence;
    private final long creationTime;

    public ArchiveorgSearchResult(String domainName, ArchiveorgItem item) {
        this.identifier = item.identifier;
        this.domainName = domainName;
        this.detailsUrl = "http://" + domainName + "/details/" + item.identifier;
        this.title = ArchiveorgSearchResult.buildTitle(item.title);
        this.licence = Licenses.creativeCommonsByUrl(item.licenseurl);
        this.creationTime = this.parsePublicDate(item.publicdate);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getDisplayName() {
        return this.title;
    }

    @Override
    public String getSource() {
        return "Archive.org";
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public License getLicense() {
        return this.licence;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    private static String buildTitle(Object obj) {
        ArrayList l;
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof ArrayList && (l = (ArrayList)obj).size() > 0) {
            return l.get(0).toString();
        }
        return "<unknown>";
    }

    private long parsePublicDate(String publicdate) {
        SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        long result = -1L;
        try {
            result = date.parse(publicdate).getTime();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getDomainName() {
        return this.domainName;
    }
}

