/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.eztv;

import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import com.frostwire.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public final class EztvSearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    public EztvSearchResult(String detailsUrl, SearchMatcher matcher) {
        this.detailsUrl = detailsUrl;
        String dispName = null;
        if (matcher.group("displayname") != null) {
            dispName = matcher.group("displayname");
        } else if (matcher.group("displayname2") != null) {
            dispName = matcher.group("displayname2");
        } else if (matcher.group("displaynamefallback") != null) {
            dispName = matcher.group("displaynamefallback");
        }
        this.displayName = HtmlManipulator.replaceHtmlEntities(dispName).trim();
        this.torrentUrl = EztvSearchResult.buildTorrentUrl(matcher);
        this.filename = this.parseFileName(FilenameUtils.getName(this.torrentUrl));
        this.infoHash = EztvSearchResult.parseInfoHash(matcher, this.torrentUrl);
        this.seeds = EztvSearchResult.parseSeeds(matcher.group("seeds"));
        this.creationTime = this.parseCreationTime(matcher.group("creationtime"));
        this.size = this.parseSize(matcher.group("filesize"));
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "Eztv";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    private String parseFileName(String urlEncodedFileName) {
        String decodedFileName = null;
        try {
            if (!StringUtils.isNullOrEmpty(urlEncodedFileName)) {
                decodedFileName = URLDecoder.decode(urlEncodedFileName, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedFileName;
    }

    private static String parseInfoHash(SearchMatcher matcher, String torrentUrl) {
        try {
            if (matcher.group("infohash") != null) {
                return matcher.group("infohash");
            }
            if (torrentUrl.startsWith("magnet:?xt=urn:btih:")) {
                return torrentUrl.substring(20, 52);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private long parseCreationTime(String dateString) {
        long result = System.currentTimeMillis();
        try {
            dateString = dateString.replaceAll("(st|nd|rd|th)", "");
            SimpleDateFormat myFormat = new SimpleDateFormat("d MMM yyyy", Locale.US);
            result = myFormat.parse(dateString).getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static String buildTorrentUrl(SearchMatcher matcher) {
        String url = null;
        if (matcher.group("torrenturl") != null) {
            url = matcher.group("torrenturl");
            url = url.replaceAll(" ", "%20");
        } else if (matcher.group("magneturl") != null) {
            url = matcher.group("magneturl");
        }
        return url;
    }

    private static int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Throwable e) {
            return 0;
        }
    }
}

