/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.filter;

import com.frostwire.search.SearchResult;
import com.frostwire.search.filter.SearchFilter;
import com.frostwire.search.filter.SearchView;
import com.frostwire.util.Ref;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class SearchTable {
    private final long token;
    private final LinkedList<SearchResult> data;
    private final LinkedList<WeakReference<SearchView>> views;
    private final Object lock;

    public SearchTable(long token) {
        this.token = token;
        this.data = new LinkedList();
        this.views = new LinkedList();
        this.lock = new Object();
    }

    public long token() {
        return this.token;
    }

    public List<SearchResult> data() {
        return Collections.unmodifiableList(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchView view(SearchFilter filter) {
        SearchView v = new SearchView(this, filter);
        Object object = this.lock;
        synchronized (object) {
            this.views.add(Ref.weak(v));
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<? extends SearchResult> results) {
        this.data.addAll(results);
        Object object = this.lock;
        synchronized (object) {
            Iterator it = this.views.iterator();
            while (it.hasNext()) {
                WeakReference r = (WeakReference)it.next();
                if (Ref.alive(r)) {
                    ((SearchView)r.get()).add(results);
                    continue;
                }
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.data.clear();
        Object object = this.lock;
        synchronized (object) {
            Iterator it = this.views.iterator();
            while (it.hasNext()) {
                WeakReference r = (WeakReference)it.next();
                if (Ref.alive(r)) {
                    ((SearchView)r.get()).clear();
                    continue;
                }
                it.remove();
            }
        }
    }

    public void add(SearchResult sr) {
        this.add(Arrays.asList(sr));
    }
}

