/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.pixabay;

import com.frostwire.search.HttpSearchResult;
import com.frostwire.search.StreamableSearchResult;
import com.frostwire.search.pixabay.PixabayItem;
import com.frostwire.search.pixabay.PixabayItemSearchResult;
import java.util.Locale;

public final class PixabayVideoSearchResult
extends PixabayItemSearchResult
implements HttpSearchResult,
StreamableSearchResult {
    private final String displayName;
    private final String filename;
    private final String thumbnailUrl;

    PixabayVideoSearchResult(PixabayItem item) {
        super(item);
        this.filename = this.displayName = item.type + "-" + item.id + ".mp4";
        this.thumbnailUrl = String.format(Locale.US, "https://i.vimeocdn.com/video/%s_100x75.jpg", item.picture_id);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    @Override
    public String getDownloadUrl() {
        return this.item.videos.tiny.url;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.item.videos.tiny.size;
    }

    @Override
    public String getStreamUrl() {
        return this.item.videos.tiny.url;
    }
}

