/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrent;

import com.frostwire.search.AbstractFileSearchResult;
import com.frostwire.search.torrent.TorrentCrawlableSearchResult;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTorrentSearchResult
extends AbstractFileSearchResult
implements TorrentCrawlableSearchResult {
    private static final long[] BYTE_MULTIPLIERS = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L};
    private static final Map<String, Integer> UNIT_TO_BYTE_MULTIPLIERS_MAP = new HashMap<String, Integer>();
    private int uid = -1;

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public String getReferrerUrl() {
        return this.getDetailsUrl();
    }

    protected long parseSize(String group) {
        String[] size = group.trim().split(" ");
        String amount = size[0].trim();
        String unit = size[1].trim();
        return this.calculateSize(amount, unit);
    }

    protected long calculateSize(String amount, String unit) {
        if (amount == null || unit == null) {
            return -1L;
        }
        Integer unitMultiplier = UNIT_TO_BYTE_MULTIPLIERS_MAP.get(unit);
        long multiplier = 1L;
        if (unitMultiplier != null) {
            multiplier = BYTE_MULTIPLIERS[unitMultiplier];
        }
        if (amount.indexOf(".") > 0) {
            float floatAmount = Float.parseFloat(amount);
            return (long)(floatAmount * (float)multiplier);
        }
        int intAmount = Integer.parseInt(amount);
        return (long)intAmount * multiplier;
    }

    static {
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("B", 0);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("octets", 0);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("KB", 1);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("MB", 2);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("GB", 3);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("TB", 4);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("PB", 5);
    }
}

