/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrent;

import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.search.AbstractCrawledSearchResult;
import com.frostwire.search.torrent.TorrentCrawlableSearchResult;
import com.frostwire.search.torrent.TorrentItemSearchResult;
import org.apache.commons.io.FilenameUtils;

public final class TorrentCrawledSearchResult
extends AbstractCrawledSearchResult<TorrentCrawlableSearchResult>
implements TorrentItemSearchResult {
    private final TorrentInfo ti;
    private final int fileIndex;
    private final String filePath;
    private final String displayName;
    private final String filename;
    private final long size;

    public TorrentCrawledSearchResult(TorrentCrawlableSearchResult sr, TorrentInfo ti, int fileIndex, String filePath, long fileSize) {
        super(sr);
        this.ti = ti;
        this.fileIndex = fileIndex;
        this.filePath = filePath;
        this.filename = FilenameUtils.getName(this.filePath);
        this.size = fileSize;
        this.displayName = FilenameUtils.getBaseName(this.filename);
    }

    public TorrentInfo getTorrentInfo() {
        return this.ti;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getTorrentUrl() {
        return ((TorrentCrawlableSearchResult)this.parent).getTorrentUrl();
    }

    @Override
    public String getReferrerUrl() {
        return ((TorrentCrawlableSearchResult)this.parent).getReferrerUrl();
    }

    @Override
    public int getSeeds() {
        return ((TorrentCrawlableSearchResult)this.parent).getSeeds();
    }

    @Override
    public String getHash() {
        return ((TorrentCrawlableSearchResult)this.parent).getHash();
    }

    @Override
    public String getThumbnailUrl() {
        return ((TorrentCrawlableSearchResult)this.parent).getThumbnailUrl();
    }
}

